/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.search;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.fragments.search.SimilarityTabOperator;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.models.search.SimilarityConfig;

public final class SimilarityPaneProvider
implements SimilarityTabOperator {
    private final JCheckBox tfidfCB = new JCheckBox();
    private final JCheckBox discardOverlapsCB = new JCheckBox();
    private final JFormattedTextField k1FTF = new JFormattedTextField();
    private final JFormattedTextField bFTF = new JFormattedTextField();
    private final SimilarityConfig config = new SimilarityConfig.Builder().build();
    private final ListenerFunctions listeners = new ListenerFunctions();

    public SimilarityPaneProvider() {
        ComponentOperatorRegistry.getInstance().register(SimilarityTabOperator.class, this);
    }

    public JScrollPane get() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.initSimilaritySettingsPanel());
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        return scrollPane;
    }

    private JPanel initSimilaritySettingsPanel() {
        JPanel panel = new JPanel(new GridLayout(4, 1));
        panel.setOpaque(false);
        panel.setMaximumSize(new Dimension(700, 220));
        this.tfidfCB.setText(MessageUtils.getLocalizedMessage("search_similarity.checkbox.use_classic"));
        this.tfidfCB.addActionListener(this.listeners::toggleTfIdf);
        this.tfidfCB.setOpaque(false);
        panel.add(this.tfidfCB);
        this.discardOverlapsCB.setText(MessageUtils.getLocalizedMessage("search_similarity.checkbox.discount_overlaps"));
        this.discardOverlapsCB.setSelected(this.config.isUseClassicSimilarity());
        this.discardOverlapsCB.setOpaque(false);
        panel.add(this.discardOverlapsCB);
        JLabel bm25Label = new JLabel(MessageUtils.getLocalizedMessage("search_similarity.label.bm25_params"));
        panel.add(bm25Label);
        JPanel bm25Params = new JPanel(new FlowLayout(3));
        bm25Params.setOpaque(false);
        bm25Params.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        JPanel k1Val = new JPanel(new FlowLayout(3));
        k1Val.setOpaque(false);
        k1Val.add(new JLabel("k1: "));
        this.k1FTF.setColumns(5);
        this.k1FTF.setValue(Float.valueOf(this.config.getK1()));
        k1Val.add(this.k1FTF);
        k1Val.add(new JLabel(MessageUtils.getLocalizedMessage("label.float_required")));
        bm25Params.add(k1Val);
        JPanel bVal = new JPanel(new FlowLayout(3));
        bVal.setOpaque(false);
        bVal.add(new JLabel("b: "));
        this.bFTF.setColumns(5);
        this.bFTF.setValue(Float.valueOf(this.config.getB()));
        bVal.add(this.bFTF);
        bVal.add(new JLabel(MessageUtils.getLocalizedMessage("label.float_required")));
        bm25Params.add(bVal);
        panel.add(bm25Params);
        return panel;
    }

    @Override
    public SimilarityConfig getConfig() {
        float k1 = ((Float)this.k1FTF.getValue()).floatValue();
        float b = ((Float)this.bFTF.getValue()).floatValue();
        return new SimilarityConfig.Builder().useClassicSimilarity(this.tfidfCB.isSelected()).discountOverlaps(this.discardOverlapsCB.isSelected()).k1(k1).b(b).build();
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void toggleTfIdf(ActionEvent e) {
            if (SimilarityPaneProvider.this.tfidfCB.isSelected()) {
                SimilarityPaneProvider.this.k1FTF.setEnabled(false);
                SimilarityPaneProvider.this.k1FTF.setBackground(StyleConstants.DISABLED_COLOR);
                SimilarityPaneProvider.this.bFTF.setEnabled(false);
                SimilarityPaneProvider.this.bFTF.setBackground(StyleConstants.DISABLED_COLOR);
            } else {
                SimilarityPaneProvider.this.k1FTF.setEnabled(true);
                SimilarityPaneProvider.this.k1FTF.setBackground(Color.white);
                SimilarityPaneProvider.this.bFTF.setEnabled(true);
                SimilarityPaneProvider.this.bFTF.setBackground(Color.white);
            }
        }
    }
}

