/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.DefaultZkCredentialsProvider;
import org.apache.solr.common.cloud.ZkCredentialsInjector;
import org.apache.solr.common.cloud.ZkCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestZkCredentialsProvider
extends DefaultZkCredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DigestZkCredentialsProvider() {
    }

    public DigestZkCredentialsProvider(ZkCredentialsInjector zkCredentialsInjector) {
        super(zkCredentialsInjector);
    }

    @Override
    protected Collection<ZkCredentialsProvider.ZkCredentials> createCredentials() {
        ArrayList<ZkCredentialsProvider.ZkCredentials> result = new ArrayList<ZkCredentialsProvider.ZkCredentials>(1);
        List<ZkCredentialsInjector.ZkCredential> zkCredentials = this.zkCredentialsInjector.getZkCredentials();
        log.debug("createCredentials using zkCredentials: {}", zkCredentials);
        for (ZkCredentialsInjector.ZkCredential zkCredential : zkCredentials) {
            if (!zkCredential.isAll() || StringUtils.isEmpty((String)zkCredential.getUsername()) || StringUtils.isEmpty((String)zkCredential.getPassword())) continue;
            result.add(new ZkCredentialsProvider.ZkCredentials("digest", (zkCredential.getUsername() + ":" + zkCredential.getPassword()).getBytes(StandardCharsets.UTF_8)));
            break;
        }
        return result;
    }
}

