/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.nar.OSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNativeLibHandlingClassLoader
extends URLClassLoader
implements OSUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<File> nativeLibDirList;
    protected final Map<String, Path> nativeLibNameToPath = new HashMap<String, Path>();
    private final String tmpLibFilePrefix;

    public AbstractNativeLibHandlingClassLoader(URL[] urls, List<File> initialNativeLibDirList, String tmpLibFilePrefix) {
        super(urls);
        this.nativeLibDirList = this.buildNativeLibDirList(initialNativeLibDirList);
        this.tmpLibFilePrefix = tmpLibFilePrefix;
    }

    public AbstractNativeLibHandlingClassLoader(URL[] urls, ClassLoader parent, List<File> initialNativeLibDirList, String tmpLibFilePrefix) {
        super(urls, parent);
        this.nativeLibDirList = this.buildNativeLibDirList(initialNativeLibDirList);
        this.tmpLibFilePrefix = tmpLibFilePrefix;
    }

    public static File toDir(File fileOrDir) {
        if (fileOrDir == null) {
            return null;
        }
        if (fileOrDir.isFile()) {
            return fileOrDir.getParentFile();
        }
        if (fileOrDir.isDirectory()) {
            return fileOrDir;
        }
        return null;
    }

    @Override
    public String findLibrary(String libname) {
        Path libLocation = this.nativeLibNameToPath.compute(libname, (__, currentLocation) -> {
            if (currentLocation != null && currentLocation.toFile().exists()) {
                return currentLocation;
            }
            for (File nativeLibDir : this.nativeLibDirList) {
                String libraryOriginalPathString = this.findLibrary(libname, nativeLibDir);
                if (libraryOriginalPathString == null) continue;
                return this.createTempCopy(libname, libraryOriginalPathString);
            }
            return null;
        });
        String libLocationString = libLocation == null ? null : libLocation.toFile().getAbsolutePath();
        return libLocationString;
    }

    protected Set<File> getUsrLibDirs() {
        Set<File> usrLibDirs = Arrays.stream(this.getJavaLibraryPath().split(File.pathSeparator)).map(String::trim).filter(pathAsString -> !pathAsString.isEmpty()).map(File::new).map(AbstractNativeLibHandlingClassLoader::toDir).filter(Objects::nonNull).collect(Collectors.toSet());
        return usrLibDirs;
    }

    protected String getJavaLibraryPath() {
        return System.getProperty("java.library.path", "");
    }

    protected Path createTempCopy(String libname, String libraryOriginalPathString) {
        Path tempFile;
        try {
            tempFile = Files.createTempFile(this.tmpLibFilePrefix + "_", "_" + libname, new FileAttribute[0]);
            Files.copy(Paths.get(libraryOriginalPathString, new String[0]), tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            this.logger.error("Couldn't create temporary copy of the library '{}' found at '{}'", new Object[]{libname, libraryOriginalPathString, e});
            tempFile = null;
        }
        return tempFile;
    }

    protected String findLibrary(String libname, File nativeLibDir) {
        File dllFile = new File(nativeLibDir, libname + ".dll");
        File dylibFile = new File(nativeLibDir, libname + ".dylib");
        File libdylibFile = new File(nativeLibDir, "lib" + libname + ".dylib");
        File libsoFile = new File(nativeLibDir, "lib" + libname + ".so");
        File soFile = new File(nativeLibDir, libname + ".so");
        if (this.isOsWindows() && dllFile.exists()) {
            return dllFile.getAbsolutePath();
        }
        if (this.isOsMac()) {
            if (dylibFile.exists()) {
                return dylibFile.getAbsolutePath();
            }
            if (libdylibFile.exists()) {
                return libdylibFile.getAbsolutePath();
            }
            if (soFile.exists()) {
                return soFile.getAbsolutePath();
            }
            if (libsoFile.exists()) {
                return libsoFile.getAbsolutePath();
            }
        } else if (this.isOsLinuxUnix()) {
            if (soFile.exists()) {
                return soFile.getAbsolutePath();
            }
            if (libsoFile.exists()) {
                return libsoFile.getAbsolutePath();
            }
        }
        return null;
    }

    private List<File> buildNativeLibDirList(List<File> initialNativeLibDirList) {
        ArrayList<File> allNativeLibDirList = new ArrayList<File>(initialNativeLibDirList);
        allNativeLibDirList.addAll(this.getUsrLibDirs());
        return Collections.unmodifiableList(allNativeLibDirList);
    }
}

