/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DF1RequestCommand is the corresponding interface of DF1RequestCommand
type DF1RequestCommand interface {
	DF1RequestCommandContract
	DF1RequestCommandRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsDF1RequestCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDF1RequestCommand()
	// CreateBuilder creates a DF1RequestCommandBuilder
	CreateDF1RequestCommandBuilder() DF1RequestCommandBuilder
}

// DF1RequestCommandContract provides a set of functions which can be overwritten by a sub struct
type DF1RequestCommandContract interface {
	// IsDF1RequestCommand is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDF1RequestCommand()
	// CreateBuilder creates a DF1RequestCommandBuilder
	CreateDF1RequestCommandBuilder() DF1RequestCommandBuilder
}

// DF1RequestCommandRequirements provides a set of functions which need to be implemented by a sub struct
type DF1RequestCommandRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetFunctionCode returns FunctionCode (discriminator field)
	GetFunctionCode() uint8
}

// _DF1RequestCommand is the data-structure of this message
type _DF1RequestCommand struct {
	_SubType interface {
		DF1RequestCommandContract
		DF1RequestCommandRequirements
	}
}

var _ DF1RequestCommandContract = (*_DF1RequestCommand)(nil)

// NewDF1RequestCommand factory function for _DF1RequestCommand
func NewDF1RequestCommand() *_DF1RequestCommand {
	return &_DF1RequestCommand{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DF1RequestCommandBuilder is a builder for DF1RequestCommand
type DF1RequestCommandBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() DF1RequestCommandBuilder
	// AsDF1RequestProtectedTypedLogicalRead converts this build to a subType of DF1RequestCommand. It is always possible to return to current builder using Done()
	AsDF1RequestProtectedTypedLogicalRead() DF1RequestProtectedTypedLogicalReadBuilder
	// Build builds the DF1RequestCommand or returns an error if something is wrong
	PartialBuild() (DF1RequestCommandContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() DF1RequestCommandContract
	// Build builds the DF1RequestCommand or returns an error if something is wrong
	Build() (DF1RequestCommand, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DF1RequestCommand
}

// NewDF1RequestCommandBuilder() creates a DF1RequestCommandBuilder
func NewDF1RequestCommandBuilder() DF1RequestCommandBuilder {
	return &_DF1RequestCommandBuilder{_DF1RequestCommand: new(_DF1RequestCommand)}
}

type _DF1RequestCommandChildBuilder interface {
	utils.Copyable
	setParent(DF1RequestCommandContract)
	buildForDF1RequestCommand() (DF1RequestCommand, error)
}

type _DF1RequestCommandBuilder struct {
	*_DF1RequestCommand

	childBuilder _DF1RequestCommandChildBuilder

	collectedErr []error
}

var _ (DF1RequestCommandBuilder) = (*_DF1RequestCommandBuilder)(nil)

func (b *_DF1RequestCommandBuilder) WithMandatoryFields() DF1RequestCommandBuilder {
	return b
}

func (b *_DF1RequestCommandBuilder) PartialBuild() (DF1RequestCommandContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._DF1RequestCommand.deepCopy(), nil
}

func (b *_DF1RequestCommandBuilder) PartialMustBuild() DF1RequestCommandContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DF1RequestCommandBuilder) AsDF1RequestProtectedTypedLogicalRead() DF1RequestProtectedTypedLogicalReadBuilder {
	if cb, ok := b.childBuilder.(DF1RequestProtectedTypedLogicalReadBuilder); ok {
		return cb
	}
	cb := NewDF1RequestProtectedTypedLogicalReadBuilder().(*_DF1RequestProtectedTypedLogicalReadBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_DF1RequestCommandBuilder) Build() (DF1RequestCommand, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForDF1RequestCommand()
}

func (b *_DF1RequestCommandBuilder) MustBuild() DF1RequestCommand {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DF1RequestCommandBuilder) DeepCopy() any {
	_copy := b.CreateDF1RequestCommandBuilder().(*_DF1RequestCommandBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_DF1RequestCommandChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateDF1RequestCommandBuilder creates a DF1RequestCommandBuilder
func (b *_DF1RequestCommand) CreateDF1RequestCommandBuilder() DF1RequestCommandBuilder {
	if b == nil {
		return NewDF1RequestCommandBuilder()
	}
	return &_DF1RequestCommandBuilder{_DF1RequestCommand: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDF1RequestCommand(structType any) DF1RequestCommand {
	if casted, ok := structType.(DF1RequestCommand); ok {
		return casted
	}
	if casted, ok := structType.(*DF1RequestCommand); ok {
		return *casted
	}
	return nil
}

func (m *_DF1RequestCommand) GetTypeName() string {
	return "DF1RequestCommand"
}

func (m *_DF1RequestCommand) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (functionCode)
	lengthInBits += 8

	return lengthInBits
}

func (m *_DF1RequestCommand) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_DF1RequestCommand) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func DF1RequestCommandParse[T DF1RequestCommand](ctx context.Context, theBytes []byte) (T, error) {
	return DF1RequestCommandParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func DF1RequestCommandParseWithBufferProducer[T DF1RequestCommand]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := DF1RequestCommandParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func DF1RequestCommandParseWithBuffer[T DF1RequestCommand](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_DF1RequestCommand{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_DF1RequestCommand) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__dF1RequestCommand DF1RequestCommand, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DF1RequestCommand"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DF1RequestCommand")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	functionCode, err := ReadDiscriminatorField[uint8](ctx, "functionCode", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'functionCode' field"))
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child DF1RequestCommand
	switch {
	case functionCode == 0xA2: // DF1RequestProtectedTypedLogicalRead
		if _child, err = new(_DF1RequestProtectedTypedLogicalRead).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DF1RequestProtectedTypedLogicalRead for type-switch of DF1RequestCommand")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [functionCode=%v]", functionCode)
	}

	if closeErr := readBuffer.CloseContext("DF1RequestCommand"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DF1RequestCommand")
	}

	return _child, nil
}

func (pm *_DF1RequestCommand) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child DF1RequestCommand, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("DF1RequestCommand"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for DF1RequestCommand")
	}

	if err := WriteDiscriminatorField(ctx, "functionCode", m.GetFunctionCode(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'functionCode' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("DF1RequestCommand"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for DF1RequestCommand")
	}
	return nil
}

func (m *_DF1RequestCommand) IsDF1RequestCommand() {}

func (m *_DF1RequestCommand) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DF1RequestCommand) deepCopy() *_DF1RequestCommand {
	if m == nil {
		return nil
	}
	_DF1RequestCommandCopy := &_DF1RequestCommand{
		nil, // will be set by child
	}
	return _DF1RequestCommandCopy
}
