/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7MessageUserData is the corresponding interface of S7MessageUserData
type S7MessageUserData interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	S7Message
	// IsS7MessageUserData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7MessageUserData()
	// CreateBuilder creates a S7MessageUserDataBuilder
	CreateS7MessageUserDataBuilder() S7MessageUserDataBuilder
}

// _S7MessageUserData is the data-structure of this message
type _S7MessageUserData struct {
	S7MessageContract
}

var _ S7MessageUserData = (*_S7MessageUserData)(nil)
var _ S7MessageRequirements = (*_S7MessageUserData)(nil)

// NewS7MessageUserData factory function for _S7MessageUserData
func NewS7MessageUserData(tpduReference uint16, parameter S7Parameter, payload S7Payload) *_S7MessageUserData {
	_result := &_S7MessageUserData{
		S7MessageContract: NewS7Message(tpduReference, parameter, payload),
	}
	_result.S7MessageContract.(*_S7Message)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7MessageUserDataBuilder is a builder for S7MessageUserData
type S7MessageUserDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() S7MessageUserDataBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() S7MessageBuilder
	// Build builds the S7MessageUserData or returns an error if something is wrong
	Build() (S7MessageUserData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7MessageUserData
}

// NewS7MessageUserDataBuilder() creates a S7MessageUserDataBuilder
func NewS7MessageUserDataBuilder() S7MessageUserDataBuilder {
	return &_S7MessageUserDataBuilder{_S7MessageUserData: new(_S7MessageUserData)}
}

type _S7MessageUserDataBuilder struct {
	*_S7MessageUserData

	parentBuilder *_S7MessageBuilder

	collectedErr []error
}

var _ (S7MessageUserDataBuilder) = (*_S7MessageUserDataBuilder)(nil)

func (b *_S7MessageUserDataBuilder) setParent(contract S7MessageContract) {
	b.S7MessageContract = contract
	contract.(*_S7Message)._SubType = b._S7MessageUserData
}

func (b *_S7MessageUserDataBuilder) WithMandatoryFields() S7MessageUserDataBuilder {
	return b
}

func (b *_S7MessageUserDataBuilder) Build() (S7MessageUserData, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._S7MessageUserData.deepCopy(), nil
}

func (b *_S7MessageUserDataBuilder) MustBuild() S7MessageUserData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7MessageUserDataBuilder) Done() S7MessageBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewS7MessageBuilder().(*_S7MessageBuilder)
	}
	return b.parentBuilder
}

func (b *_S7MessageUserDataBuilder) buildForS7Message() (S7Message, error) {
	return b.Build()
}

func (b *_S7MessageUserDataBuilder) DeepCopy() any {
	_copy := b.CreateS7MessageUserDataBuilder().(*_S7MessageUserDataBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateS7MessageUserDataBuilder creates a S7MessageUserDataBuilder
func (b *_S7MessageUserData) CreateS7MessageUserDataBuilder() S7MessageUserDataBuilder {
	if b == nil {
		return NewS7MessageUserDataBuilder()
	}
	return &_S7MessageUserDataBuilder{_S7MessageUserData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_S7MessageUserData) GetMessageType() uint8 {
	return 0x07
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_S7MessageUserData) GetParent() S7MessageContract {
	return m.S7MessageContract
}

// Deprecated: use the interface for direct cast
func CastS7MessageUserData(structType any) S7MessageUserData {
	if casted, ok := structType.(S7MessageUserData); ok {
		return casted
	}
	if casted, ok := structType.(*S7MessageUserData); ok {
		return *casted
	}
	return nil
}

func (m *_S7MessageUserData) GetTypeName() string {
	return "S7MessageUserData"
}

func (m *_S7MessageUserData) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.S7MessageContract.(*_S7Message).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_S7MessageUserData) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_S7MessageUserData) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_S7Message) (__s7MessageUserData S7MessageUserData, err error) {
	m.S7MessageContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7MessageUserData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7MessageUserData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("S7MessageUserData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7MessageUserData")
	}

	return m, nil
}

func (m *_S7MessageUserData) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_S7MessageUserData) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7MessageUserData"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for S7MessageUserData")
		}

		if popErr := writeBuffer.PopContext("S7MessageUserData"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for S7MessageUserData")
		}
		return nil
	}
	return m.S7MessageContract.(*_S7Message).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_S7MessageUserData) IsS7MessageUserData() {}

func (m *_S7MessageUserData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7MessageUserData) deepCopy() *_S7MessageUserData {
	if m == nil {
		return nil
	}
	_S7MessageUserDataCopy := &_S7MessageUserData{
		m.S7MessageContract.(*_S7Message).deepCopy(),
	}
	_S7MessageUserDataCopy.S7MessageContract.(*_S7Message)._SubType = m
	return _S7MessageUserDataCopy
}

func (m *_S7MessageUserData) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
