/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ApduDataMemoryRead extends ApduData implements Message {

  // Accessors for discriminator values.
  public Byte getApciType() {
    return (byte) 0x8;
  }

  // Properties.
  protected final byte numBytes;
  protected final int address;

  public ApduDataMemoryRead(byte numBytes, int address) {
    super();
    this.numBytes = numBytes;
    this.address = address;
  }

  public byte getNumBytes() {
    return numBytes;
  }

  public int getAddress() {
    return address;
  }

  @Override
  protected void serializeApduDataChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ApduDataMemoryRead");

    // Simple Field (numBytes)
    writeSimpleField("numBytes", numBytes, writeUnsignedByte(writeBuffer, 6));

    // Simple Field (address)
    writeSimpleField("address", address, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("ApduDataMemoryRead");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ApduDataMemoryRead _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (numBytes)
    lengthInBits += 6;

    // Simple field (address)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ApduDataBuilder staticParseApduDataBuilder(ReadBuffer readBuffer, Short dataLength)
      throws ParseException {
    readBuffer.pullContext("ApduDataMemoryRead");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte numBytes = readSimpleField("numBytes", readUnsignedByte(readBuffer, 6));

    int address = readSimpleField("address", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("ApduDataMemoryRead");
    // Create the instance
    return new ApduDataMemoryReadBuilderImpl(numBytes, address);
  }

  public static class ApduDataMemoryReadBuilderImpl implements ApduData.ApduDataBuilder {
    private final byte numBytes;
    private final int address;

    public ApduDataMemoryReadBuilderImpl(byte numBytes, int address) {
      this.numBytes = numBytes;
      this.address = address;
    }

    public ApduDataMemoryRead build() {
      ApduDataMemoryRead apduDataMemoryRead = new ApduDataMemoryRead(numBytes, address);
      return apduDataMemoryRead;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ApduDataMemoryRead)) {
      return false;
    }
    ApduDataMemoryRead that = (ApduDataMemoryRead) o;
    return (getNumBytes() == that.getNumBytes())
        && (getAddress() == that.getAddress())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNumBytes(), getAddress());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
