/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server;

import java.util.EventListener;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.core.WebSocketComponents;

public class WebSocketServerComponents
extends WebSocketComponents {
    public static final String WEBSOCKET_COMPONENTS_ATTRIBUTE = WebSocketComponents.class.getName();
    public static final String WEBSOCKET_INFLATER_POOL_ATTRIBUTE = "jetty.websocket.inflater";
    public static final String WEBSOCKET_DEFLATER_POOL_ATTRIBUTE = "jetty.websocket.deflater";
    public static final String WEBSOCKET_BUFFER_POOL_ATTRIBUTE = "jetty.websocket.bufferPool";

    WebSocketServerComponents(InflaterPool inflaterPool, DeflaterPool deflaterPool, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory, Executor executor) {
        super(null, objectFactory, bufferPool, inflaterPool, deflaterPool, executor);
    }

    public static WebSocketComponents ensureWebSocketComponents(Server server, ContextHandler contextHandler) {
        return WebSocketServerComponents.ensureWebSocketComponents(server, (Attributes)contextHandler.getContext(), (ContainerLifeCycle)contextHandler);
    }

    public static WebSocketComponents ensureWebSocketComponents(Server server) {
        return WebSocketServerComponents.ensureWebSocketComponents(server, (Attributes)server.getContext(), (ContainerLifeCycle)server);
    }

    private static WebSocketComponents ensureWebSocketComponents(Server server, final Attributes attributes, final ContainerLifeCycle container) {
        Executor executor;
        ByteBufferPool bufferPool;
        DeflaterPool deflaterPool;
        WebSocketComponents components = (WebSocketComponents)attributes.getAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
        if (components != null) {
            return components;
        }
        InflaterPool inflaterPool = (InflaterPool)attributes.getAttribute(WEBSOCKET_INFLATER_POOL_ATTRIBUTE);
        if (inflaterPool == null) {
            inflaterPool = InflaterPool.ensurePool((Container)server);
        }
        if ((deflaterPool = (DeflaterPool)attributes.getAttribute(WEBSOCKET_DEFLATER_POOL_ATTRIBUTE)) == null) {
            deflaterPool = DeflaterPool.ensurePool((Container)server);
        }
        if ((bufferPool = (ByteBufferPool)attributes.getAttribute(WEBSOCKET_BUFFER_POOL_ATTRIBUTE)) == null) {
            bufferPool = server.getByteBufferPool();
        }
        if ((executor = (Executor)attributes.getAttribute("org.eclipse.jetty.server.Executor")) == null) {
            executor = server.getThreadPool();
        }
        DecoratedObjectFactory objectFactory = (DecoratedObjectFactory)attributes.getAttribute(DecoratedObjectFactory.ATTR);
        final WebSocketServerComponents serverComponents = new WebSocketServerComponents(inflaterPool, deflaterPool, bufferPool, objectFactory, executor);
        if (objectFactory != null) {
            serverComponents.unmanage(objectFactory);
        }
        if (server.contains((Object)inflaterPool)) {
            serverComponents.unmanage(inflaterPool);
        }
        if (server.contains((Object)deflaterPool)) {
            serverComponents.unmanage(deflaterPool);
        }
        if (server.contains((Object)bufferPool)) {
            serverComponents.unmanage(bufferPool);
        }
        if (executor != null) {
            serverComponents.unmanage(executor);
        }
        container.addManaged((LifeCycle)serverComponents);
        attributes.setAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE, (Object)serverComponents);
        container.addEventListener((EventListener)new LifeCycle.Listener(){

            public void lifeCycleStopping(LifeCycle event) {
                attributes.removeAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
                container.removeBean((Object)serverComponents);
                container.removeEventListener((EventListener)((Object)this));
            }

            public String toString() {
                return String.format("%sCleanupListener", WebSocketServerComponents.class.getSimpleName());
            }
        });
        return serverComponents;
    }

    public static WebSocketComponents getWebSocketComponents(ContextHandler contextHandler) {
        return WebSocketServerComponents.getWebSocketComponents((Attributes)contextHandler.getContext());
    }

    public static WebSocketComponents getWebSocketComponents(Server server) {
        return WebSocketServerComponents.getWebSocketComponents((Attributes)server.getContext());
    }

    private static WebSocketComponents getWebSocketComponents(Attributes attributes) {
        WebSocketComponents components = (WebSocketComponents)attributes.getAttribute(WEBSOCKET_COMPONENTS_ATTRIBUTE);
        if (components == null) {
            throw new IllegalStateException("WebSocketComponents has not been created");
        }
        return components;
    }
}

