/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.ranger.entity.XXRangerMasterKey;
import org.apache.ranger.kms.dao.DaoManager;
import org.apache.ranger.kms.dao.RangerMasterKeyDao;
import org.apache.ranger.plugin.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerMasterKey
implements RangerKMSMKI {
    private static final Logger logger = LoggerFactory.getLogger(RangerMasterKey.class);
    private static final String DEFAULT_MK_CIPHER = "AES";
    private static final int DEFAULT_MK_KeySize = 256;
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final String DEFAULT_SALT = "abcdefghijklmnopqrstuvwxyz01234567890";
    private static final String DEFAULT_CRYPT_ALGO = "PBEWithMD5AndTripleDES";
    private static final int DEFAULT_ITERATION_COUNT = 1000;
    private static final Properties serverConfigProperties = new Properties();
    public static final String DBKS_SITE_XML = "dbks-site.xml";
    private static String password = null;
    private static String DEFAULT_MD_ALGO;
    public static String MK_CIPHER;
    public static Integer MK_KeySize;
    public static Integer SALT_SIZE;
    public static String SALT;
    public static String PBE_ALGO;
    public static String MD_ALGO;
    public static Integer ITERATION_COUNT;
    public static String paddingString;
    private final RangerMasterKeyDao masterKeyDao;

    public RangerMasterKey() {
        this.masterKeyDao = null;
    }

    public RangerMasterKey(DaoManager daoManager) {
        this.masterKeyDao = daoManager != null ? daoManager.getRangerMasterKeyDao() : null;
    }

    protected static String getConfig(String key, String defaultValue) {
        String value = serverConfigProperties.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            value = System.getProperty(key);
        }
        if (value == null || value.trim().isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    protected static int getIntConfig(String key, int defaultValue) {
        int ret = defaultValue;
        String retStr = serverConfigProperties.getProperty(key);
        try {
            if (retStr != null) {
                ret = Integer.parseInt(retStr);
            }
        }
        catch (Exception err) {
            logger.warn("Key can not be parsed to int due to NumberFormatException");
        }
        return ret;
    }

    @Override
    public String getMasterKey(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.getMasterKey()");
        }
        logger.info("Getting Master Key");
        List result = this.getEncryptedMK();
        String encryptedPassString = null;
        byte[] masterKeyByte = null;
        if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == 2) {
            masterKeyByte = (byte[])result.get(0);
            encryptedPassString = (String)result.get(1);
        } else if (CollectionUtils.isNotEmpty((Collection)result)) {
            masterKeyByte = (byte[])result.get(0);
        }
        if (masterKeyByte != null && masterKeyByte.length > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("<== RangerMasterKey.getMasterKey()");
            }
            return this.decryptMasterKey(masterKeyByte, password, encryptedPassString);
        }
        throw new Exception("No Master Key Found");
    }

    public SecretKey getMasterSecretKey(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.getMasterSecretKey()");
        }
        logger.info("Getting Master Key");
        List result = this.getEncryptedMK();
        String encryptedPassString = null;
        byte[] masterKeyByte = null;
        if (CollectionUtils.isNotEmpty((Collection)result) && result.size() == 2) {
            masterKeyByte = (byte[])result.get(0);
            encryptedPassString = (String)result.get(1);
        } else if (CollectionUtils.isNotEmpty((Collection)result)) {
            masterKeyByte = (byte[])result.get(0);
        }
        if (masterKeyByte != null && masterKeyByte.length > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("<== RangerMasterKey.getMasterSecretKey()");
            }
            return this.decryptMasterKeySK(masterKeyByte, password, encryptedPassString);
        }
        throw new Exception("No Master Key Found");
    }

    public void init() {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.init()");
        }
        XMLUtils.loadConfig((String)DBKS_SITE_XML, (Map)serverConfigProperties);
        DEFAULT_MD_ALGO = RangerMasterKey.getConfig("ranger.keystore.file.type", KeyStore.getDefaultType()).equalsIgnoreCase("bcfks") ? "SHA-512" : "MD5";
        MK_CIPHER = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.cipher", DEFAULT_MK_CIPHER);
        MK_KeySize = RangerMasterKey.getIntConfig("ranger.kms.service.masterkey.password.size", 256);
        SALT_SIZE = RangerMasterKey.getIntConfig("ranger.kms.service.masterkey.password.salt.size", 8);
        SALT = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.salt", DEFAULT_SALT);
        PBE_ALGO = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.encryption.algorithm", DEFAULT_CRYPT_ALGO);
        MD_ALGO = RangerMasterKey.getConfig("ranger.kms.service.masterkey.password.md.algorithm", DEFAULT_MD_ALGO);
        ITERATION_COUNT = RangerMasterKey.getIntConfig("ranger.kms.service.masterkey.password.iteration.count", 1000);
        paddingString = Joiner.on((String)",").skipNulls().join((Object)MK_CIPHER, (Object)MK_KeySize, new Object[]{SALT_SIZE, PBE_ALGO, MD_ALGO, ITERATION_COUNT, SALT});
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.init()");
        }
    }

    @Override
    public boolean generateMasterKey(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.generateMasterKey()");
        }
        logger.info("Generating Master Key...");
        this.init();
        if (!this.checkMKExistence(this.masterKeyDao)) {
            logger.info("Master Key doesn't exist in DB, Generating the Master Key");
            String encryptedMasterKey = this.encryptMasterKey(password);
            String savedKey = this.saveEncryptedMK(paddingString + "," + encryptedMasterKey);
            if (savedKey != null && !savedKey.trim().equals("")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Master Key Created with id = " + savedKey);
                    logger.debug("<== RangerMasterKey.generateMasterKey()");
                }
                return true;
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Ranger Master Key already exists in the DB, returning.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.generateMasterKey()");
        }
        return false;
    }

    public void generateMKFromHSMMK(String password, byte[] key) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.generateMKFromHSMMK()");
        }
        this.init();
        if (!this.checkMKExistence(this.masterKeyDao)) {
            logger.info("Master Key doesn't exist in DB, Generating the Master Key");
            String encryptedMasterKey = this.encryptMasterKey(password, key);
            String savedKey = this.saveEncryptedMK(paddingString + "," + encryptedMasterKey);
            if (savedKey != null && !savedKey.trim().equals("") && logger.isDebugEnabled()) {
                logger.debug("Master Key Created with id = " + savedKey);
                logger.debug("<== RangerMasterKey.generateMKFromHSMMK()");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Ranger Master Key already exists in the DB, returning.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.generateMKFromHSMMK()");
        }
    }

    private String decryptMasterKey(byte[] masterKey, String password, String encryptedPassString) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.decryptMasterKey()");
            logger.debug("Decrypting Master Key...");
        }
        if (encryptedPassString == null) {
            RangerMasterKey.getPasswordParam(password);
        }
        PBEKeySpec pbeKeyspec = this.getPBEParameterSpec(password);
        byte[] masterKeyFromDBDecrypted = this.decryptKey(masterKey, pbeKeyspec);
        SecretKey masterKeyFromDB = this.getMasterKeyFromBytes(masterKeyFromDBDecrypted);
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.decryptMasterKey()");
        }
        return Base64.encode(masterKeyFromDB.getEncoded());
    }

    public static void getPasswordParam(String paddedEncryptedPwd) {
        String[] encryptedPwd = null;
        if (paddedEncryptedPwd != null && paddedEncryptedPwd.contains(",")) {
            encryptedPwd = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)paddedEncryptedPwd)).toArray(new String[0]);
        }
        if (encryptedPwd != null && encryptedPwd.length >= 7) {
            int index = 0;
            MK_CIPHER = encryptedPwd[index];
            MK_KeySize = Integer.parseInt(encryptedPwd[++index]);
            SALT_SIZE = Integer.parseInt(encryptedPwd[++index]);
            PBE_ALGO = encryptedPwd[++index];
            MD_ALGO = encryptedPwd[++index];
            ITERATION_COUNT = Integer.parseInt(encryptedPwd[++index]);
            SALT = encryptedPwd[++index];
            password = encryptedPwd[++index];
        } else {
            MK_CIPHER = DEFAULT_MK_CIPHER;
            MK_KeySize = 256;
            SALT_SIZE = 8;
            PBE_ALGO = DEFAULT_CRYPT_ALGO;
            MD_ALGO = DEFAULT_MD_ALGO;
            SALT = password = paddedEncryptedPwd;
            if (password != null) {
                ITERATION_COUNT = password.toCharArray().length + 1;
            }
        }
    }

    public void generateMKFromKeySecureMK(String password, byte[] key) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.generateMKFromKeySecureMK()");
        }
        this.init();
        if (!this.checkMKExistence(this.masterKeyDao)) {
            logger.info("Master Key doesn't exist in DB, Generating the Master Key");
            String encryptedMasterKey = this.encryptMasterKey(password, key);
            String savedKey = this.saveEncryptedMK(paddingString + "," + encryptedMasterKey);
            if (savedKey != null && !savedKey.trim().equals("")) {
                logger.debug("Master Key Created with id = " + savedKey);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Ranger Master Key already exists in the DB, returning.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.generateMKFromKeySecureMK()");
        }
    }

    private SecretKey decryptMasterKeySK(byte[] masterKey, String password, String encryptedPassString) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.decryptMasterKeySK()");
        }
        if (encryptedPassString == null) {
            RangerMasterKey.getPasswordParam(password);
        }
        PBEKeySpec pbeKeyspec = this.getPBEParameterSpec(password);
        byte[] masterKeyFromDBDecrypted = this.decryptKey(masterKey, pbeKeyspec);
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.decryptMasterKeySK()");
        }
        return this.getMasterKeyFromBytes(masterKeyFromDBDecrypted);
    }

    private List getEncryptedMK() {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.getEncryptedMK()");
        }
        try {
            if (this.masterKeyDao != null) {
                ArrayList<Object> ret = new ArrayList<Object>();
                List lstRangerMasterKey = this.masterKeyDao.getAll();
                if (lstRangerMasterKey.size() < 1) {
                    throw new Exception("No Master Key exists");
                }
                if (lstRangerMasterKey.size() > 1) {
                    throw new Exception("More than one Master Key exists");
                }
                XXRangerMasterKey rangerMasterKey = (XXRangerMasterKey)this.masterKeyDao.getById(((XXRangerMasterKey)lstRangerMasterKey.get(0)).getId());
                String masterKeyStr = rangerMasterKey.getMasterKey();
                if (masterKeyStr.contains(",")) {
                    RangerMasterKey.getPasswordParam(masterKeyStr);
                    ret.add(Base64.decode(password));
                    ret.add(masterKeyStr);
                } else {
                    ret.add(Base64.decode(masterKeyStr));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("<== RangerMasterKey.getEncryptedMK()");
                }
                return ret;
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve Master Key from the database!!!", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.getEncryptedMK()");
        }
        return null;
    }

    private String saveEncryptedMK(String encryptedMasterKey) {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.saveEncryptedMK()");
        }
        XXRangerMasterKey xxRangerMasterKey = new XXRangerMasterKey();
        xxRangerMasterKey.setCipher(MK_CIPHER);
        xxRangerMasterKey.setBitLength(MK_KeySize);
        xxRangerMasterKey.setMasterKey(encryptedMasterKey);
        try {
            if (this.masterKeyDao != null) {
                XXRangerMasterKey rangerMasterKey = this.masterKeyDao.create(xxRangerMasterKey);
                if (logger.isDebugEnabled()) {
                    logger.debug("<== RangerMasterKey.saveEncryptedMK()");
                }
                return rangerMasterKey.getId().toString();
            }
        }
        catch (Exception e) {
            logger.error("Error while saving master key in Database!!! ", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.saveEncryptedMK()");
        }
        return null;
    }

    private boolean checkMKExistence(RangerMasterKeyDao rangerMKDao) {
        boolean mkExists = false;
        if (rangerMKDao != null) {
            mkExists = rangerMKDao.getAllCount() >= 1L;
        }
        return mkExists;
    }

    private String encryptMasterKey(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.encryptMasterKey()");
        }
        Key secretKey = this.generateMasterKey();
        PBEKeySpec pbeKeySpec = this.getPBEParameterSpec(password);
        byte[] masterKeyToDB = this.encryptKey(secretKey.getEncoded(), pbeKeySpec);
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.encryptMasterKey()");
        }
        return Base64.encode(masterKeyToDB);
    }

    private String encryptMasterKey(String password, byte[] secretKey) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.encryptMasterKey()");
        }
        PBEKeySpec pbeKeySpec = this.getPBEParameterSpec(password);
        byte[] masterKeyToDB = this.encryptKey(secretKey, pbeKeySpec);
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.encryptMasterKey()");
        }
        return Base64.encode(masterKeyToDB);
    }

    private Key generateMasterKey() throws NoSuchAlgorithmException {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.generateMasterKey()");
        }
        KeyGenerator kg = KeyGenerator.getInstance(MK_CIPHER);
        kg.init(MK_KeySize);
        return kg.generateKey();
    }

    private PBEKeySpec getPBEParameterSpec(String password) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.getPBEParameterSpec()");
        }
        MessageDigest md = MessageDigest.getInstance(MD_ALGO);
        byte[] saltGen = md.digest(SALT.getBytes());
        byte[] salt = new byte[SALT_SIZE.intValue()];
        System.arraycopy(saltGen, 0, salt, 0, SALT_SIZE);
        return new PBEKeySpec(password.toCharArray(), salt, ITERATION_COUNT);
    }

    private byte[] encryptKey(byte[] data, PBEKeySpec keyspec) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.encryptKey()");
        }
        SecretKey key = this.getPasswordKey(keyspec);
        if (keyspec.getSalt() != null) {
            PBEParameterSpec paramSpec = new PBEParameterSpec(keyspec.getSalt(), keyspec.getIterationCount());
            Cipher c = Cipher.getInstance(key.getAlgorithm());
            c.init(1, (Key)key, paramSpec);
            if (logger.isDebugEnabled()) {
                logger.debug("<== RangerMasterKey.encryptKey()");
            }
            return c.doFinal(data);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.encryptKey()");
        }
        return null;
    }

    private SecretKey getPasswordKey(PBEKeySpec keyspec) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerMasterKey.getPasswordKey()");
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance(PBE_ALGO);
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerMasterKey.getPasswordKey()");
        }
        return factory.generateSecret(keyspec);
    }

    private byte[] decryptKey(byte[] encrypted, PBEKeySpec keySpec) throws Throwable {
        SecretKey key = this.getPasswordKey(keySpec);
        if (keySpec.getSalt() != null) {
            PBEParameterSpec paramSpec = new PBEParameterSpec(keySpec.getSalt(), keySpec.getIterationCount());
            Cipher c = Cipher.getInstance(key.getAlgorithm());
            c.init(2, (Key)key, paramSpec);
            return c.doFinal(encrypted);
        }
        return null;
    }

    private SecretKey getMasterKeyFromBytes(byte[] keyData) {
        return new SecretKeySpec(keyData, MK_CIPHER);
    }

    static {
        MK_KeySize = 0;
        SALT_SIZE = 0;
        ITERATION_COUNT = 0;
    }
}

