/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlasrest;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.atlas.AtlasClientV2;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.tagsync.model.AbstractTagSource;
import org.apache.ranger.tagsync.model.TagSink;
import org.apache.ranger.tagsync.process.TagSyncConfig;
import org.apache.ranger.tagsync.process.TagSynchronizer;
import org.apache.ranger.tagsync.source.atlas.AtlasNotificationMapper;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapperUtil;
import org.apache.ranger.tagsync.source.atlas.EntityNotificationWrapper;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntityWithTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasRESTTagSource
extends AbstractTagSource
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasRESTTagSource.class);
    private static final ThreadLocal<DateFormat> DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private long sleepTimeBetweenCycleInMillis;
    private String[] restUrls = null;
    private boolean isKerberized = false;
    private String[] userNamePassword = null;
    private int entitiesBatchSize = 10000;
    private Thread myThread = null;

    public static void main(String[] args) {
        AtlasRESTTagSource atlasRESTTagSource = new AtlasRESTTagSource();
        TagSyncConfig config = TagSyncConfig.getInstance();
        Properties props = config.getProperties();
        TagSynchronizer.printConfigurationProperties(props);
        boolean ret = TagSynchronizer.initializeKerberosIdentity(props);
        if (ret) {
            TagSink tagSink = TagSynchronizer.initializeTagSink(props);
            if (tagSink != null) {
                if (atlasRESTTagSource.initialize(props)) {
                    try {
                        tagSink.start();
                        atlasRESTTagSource.setTagSink(tagSink);
                        atlasRESTTagSource.synchUp();
                    }
                    catch (Exception exception) {
                        LOG.error("ServiceTags upload failed : ", (Throwable)exception);
                        System.exit(1);
                    }
                } else {
                    LOG.error("AtlasRESTTagSource initialization failed, exiting.");
                    System.exit(1);
                }
            } else {
                LOG.error("TagSink initialization failed, exiting.");
                System.exit(1);
            }
        } else {
            LOG.error("Error initializing kerberos identity");
            System.exit(1);
        }
    }

    @Override
    public boolean initialize(Properties properties) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRESTTagSource.initialize()");
        }
        boolean ret = AtlasResourceMapperUtil.initializeAtlasResourceMappers(properties);
        this.sleepTimeBetweenCycleInMillis = TagSyncConfig.getTagSourceAtlasDownloadIntervalInMillis(properties);
        this.isKerberized = TagSyncConfig.getTagsyncKerberosIdentity(properties) != null;
        this.entitiesBatchSize = TagSyncConfig.getAtlasRestSourceEntitiesBatchSize(properties);
        String restEndpoint = TagSyncConfig.getAtlasRESTEndpoint(properties);
        String sslConfigFile = TagSyncConfig.getAtlasRESTSslConfigFile(properties);
        this.userNamePassword = new String[]{TagSyncConfig.getAtlasRESTUserName(properties), TagSyncConfig.getAtlasRESTPassword(properties)};
        if (LOG.isDebugEnabled()) {
            LOG.debug("restUrl=" + restEndpoint);
            LOG.debug("sslConfigFile=" + sslConfigFile);
            LOG.debug("userName=" + this.userNamePassword[0]);
            LOG.debug("kerberized=" + this.isKerberized);
        }
        if (StringUtils.isNotEmpty((String)restEndpoint)) {
            this.restUrls = restEndpoint.split(",");
            for (int i = 0; i < this.restUrls.length; ++i) {
                if (this.restUrls[i].endsWith("/")) continue;
                int n = i;
                this.restUrls[n] = this.restUrls[n] + "/";
            }
        } else {
            LOG.info("AtlasEndpoint not specified, Initial download of Atlas-entities cannot be done.");
            ret = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasRESTTagSource.initialize(), result=" + ret);
        }
        return ret;
    }

    @Override
    public boolean start() {
        this.myThread = new Thread(this);
        this.myThread.setDaemon(true);
        this.myThread.start();
        return true;
    }

    @Override
    public void stop() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.myThread.interrupt();
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasRESTTagSource.run()");
        }
        try {
            while (true) {
                if (TagSyncConfig.isTagSyncServiceActive()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("==> AtlasRESTTagSource.run() is running as server is Active");
                    }
                    this.synchUp();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("==> This server is running passive mode");
                }
                LOG.debug("Sleeping for [" + this.sleepTimeBetweenCycleInMillis + "] milliSeconds");
                Thread.sleep(this.sleepTimeBetweenCycleInMillis);
            }
        }
        catch (InterruptedException exception) {
            LOG.error("Interrupted..: ", (Throwable)exception);
            return;
        }
        catch (Exception e) {
            LOG.error("Caught exception", (Throwable)e);
            return;
        }
    }

    public void synchUp() throws Exception {
        List<RangerAtlasEntityWithTags> rangerAtlasEntities = this.getAtlasActiveEntities();
        if (CollectionUtils.isNotEmpty(rangerAtlasEntities)) {
            Map<String, ServiceTags> serviceTagsMap;
            if (LOG.isDebugEnabled()) {
                for (RangerAtlasEntityWithTags element : rangerAtlasEntities) {
                    LOG.debug("", (Object)element);
                }
            }
            if (MapUtils.isNotEmpty(serviceTagsMap = AtlasNotificationMapper.processAtlasEntities(rangerAtlasEntities))) {
                for (Map.Entry<String, ServiceTags> entry : serviceTagsMap.entrySet()) {
                    if (LOG.isDebugEnabled()) {
                        try {
                            String serviceTagsString = JsonUtils.objectToJson((Object)entry.getValue());
                            LOG.debug("serviceTags=" + serviceTagsString);
                        }
                        catch (Exception e) {
                            LOG.error("An error occurred while conveting serviceTags to string", (Throwable)e);
                        }
                    }
                    this.updateSink(entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<RangerAtlasEntityWithTags> getAtlasActiveEntities() {
        if (AtlasRESTTagSource.LOG.isDebugEnabled()) {
            AtlasRESTTagSource.LOG.debug("==> getAtlasActiveEntities()");
        }
        ret = new ArrayList<RangerAtlasEntityWithTags>();
        atlasClient = null;
        try {
            atlasClient = this.getAtlasClient();
        }
        catch (IOException exception) {
            AtlasRESTTagSource.LOG.error("Failed to get Atlas client.", (Throwable)exception);
        }
        if (atlasClient != null) {
            searchParams = new SearchParameters();
            searchParams.setExcludeDeletedEntities(true);
            searchParams.setClassification("*");
            searchParams.setIncludeClassificationAttributes(true);
            searchParams.setLimit(this.entitiesBatchSize);
            nextStartIndex = 0;
            do {
                typeRegistry = new AtlasTypeRegistry();
                tty = null;
                searchResult = null;
                commitUpdates = false;
                searchParams.setOffset(nextStartIndex);
                isMoreData = false;
                try {
                    searchResult = atlasClient.facetedSearch(searchParams);
                    typesDef = atlasClient.getAllTypeDefs(new SearchFilter());
                    tty = typeRegistry.lockTypeRegistryForUpdate();
                    tty.addTypes(typesDef);
                    commitUpdates = true;
                    ** if (tty == null) goto lbl-1000
                }
                catch (AtlasServiceException | AtlasBaseException excp) {
                    AtlasRESTTagSource.LOG.error("failed to download tags from Atlas", excp);
                    ret = null;
                    ** if (tty == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        typeRegistry.releaseTypeRegistryForUpdate(tty, commitUpdates);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Exception unexpectedException) {
                    AtlasRESTTagSource.LOG.error("Failed to download tags from Atlas due to unexpected exception", (Throwable)unexpectedException);
                    ret = null;
                    ** if (tty == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        typeRegistry.releaseTypeRegistryForUpdate(tty, commitUpdates);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    {
                        catch (Throwable var11_15) {
                            if (tty != null) {
                                typeRegistry.releaseTypeRegistryForUpdate(tty, commitUpdates);
                            }
                            throw var11_15;
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                    typeRegistry.releaseTypeRegistryForUpdate(tty, commitUpdates);
                }
lbl-1000:
                // 2 sources

                {
                }
                if (!commitUpdates || searchResult == null) continue;
                if (AtlasRESTTagSource.LOG.isDebugEnabled()) {
                    AtlasRESTTagSource.LOG.debug(AtlasType.toJson((Object)searchResult));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(entityHeaders = searchResult.getEntities()))) continue;
                nextStartIndex += entityHeaders.size();
                isMoreData = true;
                for (AtlasEntityHeader header : entityHeaders) {
                    if (!header.getStatus().equals((Object)AtlasEntity.Status.ACTIVE)) {
                        if (!AtlasRESTTagSource.LOG.isDebugEnabled()) continue;
                        AtlasRESTTagSource.LOG.debug("Skipping entity because it is not ACTIVE, header:[" + header + "]");
                        continue;
                    }
                    typeName = header.getTypeName();
                    if (!AtlasResourceMapperUtil.isEntityTypeHandled(typeName)) {
                        if (!AtlasRESTTagSource.LOG.isDebugEnabled()) continue;
                        AtlasRESTTagSource.LOG.debug("Not fetching Atlas entities of type:[" + typeName + "]");
                        continue;
                    }
                    allTagsForEntity = new ArrayList<EntityNotificationWrapper.RangerAtlasClassification>();
                    for (AtlasClassification classification : header.getClassifications()) {
                        tags = this.resolveTag(typeRegistry, classification);
                        if (tags == null) continue;
                        allTagsForEntity.addAll(tags);
                    }
                    if (!CollectionUtils.isNotEmpty(allTagsForEntity)) continue;
                    entity = new RangerAtlasEntity(typeName, header.getGuid(), header.getAttributes());
                    entityWithTags = new RangerAtlasEntityWithTags(entity, allTagsForEntity, typeRegistry);
                    ret.add(entityWithTags);
                }
            } while (isMoreData);
        }
        if (AtlasRESTTagSource.LOG.isDebugEnabled()) {
            AtlasRESTTagSource.LOG.debug("<== getAtlasActiveEntities()");
        }
        return ret;
    }

    private List<EntityNotificationWrapper.RangerAtlasClassification> resolveTag(AtlasTypeRegistry typeRegistry, AtlasClassification classification) {
        ArrayList<EntityNotificationWrapper.RangerAtlasClassification> ret = new ArrayList<EntityNotificationWrapper.RangerAtlasClassification>();
        String typeName = classification.getTypeName();
        Map attributes = classification.getAttributes();
        try {
            AtlasClassificationType classificationType = typeRegistry.getClassificationTypeByName(typeName);
            if (classificationType != null) {
                HashMap<String, String> allAttributes = new HashMap<String, String>();
                if (MapUtils.isNotEmpty((Map)attributes) && MapUtils.isNotEmpty((Map)classificationType.getAllAttributes())) {
                    for (Map.Entry attribute : attributes.entrySet()) {
                        String name = (String)attribute.getKey();
                        Object value = attribute.getValue();
                        if (value == null) continue;
                        String stringValue = value.toString();
                        AtlasStructType.AtlasAttribute atlasAttribute = classificationType.getAttribute(name);
                        if (atlasAttribute == null) continue;
                        if (value instanceof Number && atlasAttribute.getAttributeType() instanceof AtlasBuiltInTypes.AtlasDateType) {
                            stringValue = DATE_FORMATTER.get().format(value);
                        }
                        allAttributes.put(name, stringValue);
                    }
                }
                List validityPeriods = classification.getValidityPeriods();
                List<RangerValiditySchedule> validitySchedules = null;
                if (CollectionUtils.isNotEmpty((Collection)validityPeriods)) {
                    validitySchedules = EntityNotificationWrapper.convertTimeSpecFromAtlasToRanger(validityPeriods);
                }
                ret.add(new EntityNotificationWrapper.RangerAtlasClassification(typeName, allAttributes, validitySchedules));
                Set superTypeNames = classificationType.getAllSuperTypes();
                for (String superTypeName : superTypeNames) {
                    AtlasClassificationType superType = typeRegistry.getClassificationTypeByName(superTypeName);
                    if (superType == null) continue;
                    HashMap<String, String> attributeMap = new HashMap<String, String>();
                    if (MapUtils.isNotEmpty((Map)attributes) && MapUtils.isNotEmpty((Map)superType.getAllAttributes())) {
                        for (String name : superType.getAllAttributes().keySet()) {
                            String stringValue = (String)allAttributes.get(name);
                            if (stringValue == null) continue;
                            attributeMap.put(name, stringValue);
                        }
                    }
                    validityPeriods = classification.getValidityPeriods();
                    validitySchedules = null;
                    if (CollectionUtils.isNotEmpty((Collection)validityPeriods)) {
                        validitySchedules = EntityNotificationWrapper.convertTimeSpecFromAtlasToRanger(validityPeriods);
                    }
                    ret.add(new EntityNotificationWrapper.RangerAtlasClassification(superTypeName, attributeMap, validitySchedules));
                }
            }
        }
        catch (Exception exception) {
            LOG.error("Error in resolving tags for type:[" + typeName + "]", (Throwable)exception);
        }
        return ret;
    }

    private AtlasClientV2 getAtlasClient() throws IOException {
        AtlasClientV2 ret;
        if (this.isKerberized) {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            ugi.checkTGTAndReloginFromKeytab();
            ret = new AtlasClientV2(ugi, ugi.getShortUserName(), this.restUrls);
        } else {
            ret = new AtlasClientV2(this.restUrls, this.userNamePassword);
        }
        return ret;
    }
}

