/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.hadoop.utils.RangerCredentialProvider;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.authorization.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRESTClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerRESTClient.class);
    public static final String RANGER_PROP_POLICYMGR_URL = "ranger.service.store.rest.url";
    public static final String RANGER_PROP_POLICYMGR_SSLCONFIG_FILENAME = "ranger.service.store.rest.ssl.config.file";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE = "xasecure.policymgr.clientssl.keystore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE = "xasecure.policymgr.clientssl.keystore.type";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.keystore.credential.file";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS = "sslKeyStore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE_DEFAULT = "jks";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE = "xasecure.policymgr.clientssl.truststore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE = "xasecure.policymgr.clientssl.truststore.type";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.truststore.credential.file";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS = "sslTrustStore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String RANGER_SSL_KEYMANAGER_ALGO_TYPE = KeyManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_TRUSTMANAGER_ALGO_TYPE = TrustManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_CONTEXT_ALGO_TYPE = "TLSv1.2";
    private String mUrl;
    private String mSslConfigFileName;
    private String mUsername;
    private String mPassword;
    private boolean mIsSSL;
    private String mKeyStoreURL;
    private String mKeyStoreAlias;
    private String mKeyStoreFile;
    private String mKeyStoreType;
    private String mTrustStoreURL;
    private String mTrustStoreAlias;
    private String mTrustStoreFile;
    private String mTrustStoreType;
    private int mRestClientConnTimeOutMs;
    private int mRestClientReadTimeOutMs;
    private int maxRetryAttempts;
    private int retryIntervalMs;
    private int lastKnownActiveUrlIndex;
    private final List<String> configuredURLs;
    private volatile Client client;
    private volatile Client cookieAuthClient;
    private ClientFilter basicAuthFilter = null;

    public RangerRESTClient(String url, String sslConfigFileName, Configuration config) {
        this.mUrl = url;
        this.mSslConfigFileName = sslConfigFileName;
        this.configuredURLs = StringUtil.getURLs(this.mUrl);
        this.setLastKnownActiveUrlIndex(new Random().nextInt(this.getConfiguredURLs().size()));
        this.init(config);
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getRestClientConnTimeOutMs() {
        return this.mRestClientConnTimeOutMs;
    }

    public void setRestClientConnTimeOutMs(int mRestClientConnTimeOutMs) {
        this.mRestClientConnTimeOutMs = mRestClientConnTimeOutMs;
    }

    public int getRestClientReadTimeOutMs() {
        return this.mRestClientReadTimeOutMs;
    }

    public void setRestClientReadTimeOutMs(int mRestClientReadTimeOutMs) {
        this.mRestClientReadTimeOutMs = mRestClientReadTimeOutMs;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setMaxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public int getRetryIntervalMs() {
        return this.retryIntervalMs;
    }

    public void setRetryIntervalMs(int retryIntervalMs) {
        this.retryIntervalMs = retryIntervalMs;
    }

    public void setBasicAuthInfo(String username, String password) {
        this.mUsername = username;
        this.mPassword = password;
        this.setBasicAuthFilter(username, password);
    }

    public WebResource getResource(String relativeUrl) {
        WebResource ret = this.getClient().resource(this.getUrl() + relativeUrl);
        return ret;
    }

    public String toJson(Object obj) {
        return JsonUtils.objectToJson(obj);
    }

    public <T> T fromJson(String json, Class<T> cls) {
        return JsonUtils.jsonToObject(json, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient() {
        Client result = this.client;
        if (result == null) {
            RangerRESTClient rangerRESTClient = this;
            synchronized (rangerRESTClient) {
                result = this.client;
                if (result == null) {
                    this.client = result = this.buildClient();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client getCookieAuthClient() {
        Client ret = this.cookieAuthClient;
        if (ret == null) {
            RangerRESTClient rangerRESTClient = this;
            synchronized (rangerRESTClient) {
                ret = this.cookieAuthClient;
                if (ret == null) {
                    this.cookieAuthClient = this.buildClient();
                    if (this.basicAuthFilter != null) {
                        this.cookieAuthClient.removeFilter(this.basicAuthFilter);
                    }
                    ret = this.cookieAuthClient;
                }
            }
        }
        return ret;
    }

    private Client buildClient() {
        Client client = null;
        if (this.mIsSSL) {
            KeyManager[] kmList = this.getKeyManagers();
            TrustManager[] tmList = this.getTrustManagers();
            SSLContext sslContext = this.getSSLContext(kmList, tmList);
            DefaultClientConfig config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return session.getPeerHost().equals(urlHostName);
                }
            };
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, sslContext));
            client = Client.create((ClientConfig)config);
        }
        if (client == null) {
            DefaultClientConfig config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            client = Client.create((ClientConfig)config);
        }
        if (this.basicAuthFilter != null && !client.isFilterPresent(this.basicAuthFilter)) {
            client.addFilter(this.basicAuthFilter);
        }
        client.setConnectTimeout(Integer.valueOf(this.mRestClientConnTimeOutMs));
        client.setReadTimeout(Integer.valueOf(this.mRestClientReadTimeOutMs));
        return client;
    }

    private void setBasicAuthFilter(String username, String password) {
        this.basicAuthFilter = StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password) ? new HTTPBasicAuthFilter(username, password) : null;
    }

    public void resetClient() {
        this.client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Configuration config) {
        this.mIsSSL = this.isSslEnabled(this.mUrl);
        if (this.mIsSSL) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(this.mSslConfigFileName);
                if (in != null) {
                    config.addResource(in);
                }
                this.mKeyStoreURL = config.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL);
                this.mKeyStoreAlias = RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS;
                this.mKeyStoreType = config.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE, "jks");
                this.mKeyStoreFile = config.get(RANGER_POLICYMGR_CLIENT_KEY_FILE);
                this.mTrustStoreURL = config.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL);
                this.mTrustStoreAlias = RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS;
                this.mTrustStoreType = config.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE, "jks");
                this.mTrustStoreFile = config.get(RANGER_POLICYMGR_TRUSTSTORE_FILE);
            }
            catch (IOException ioe) {
                LOG.error("Unable to load SSL Config FileName: [" + this.mSslConfigFileName + "]", (Throwable)ioe);
            }
            finally {
                this.close(in, this.mSslConfigFileName);
            }
        }
        String pluginPropertyPrefix = config instanceof RangerPluginConfig ? ((RangerPluginConfig)config).getPropertyPrefix() : "ranger.plugin";
        String username = config.get(pluginPropertyPrefix + ".policy.rest.client.username");
        String password = config.get(pluginPropertyPrefix + ".policy.rest.client.password");
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
            this.setBasicAuthFilter(username, password);
        }
    }

    private boolean isSslEnabled(String url) {
        return !StringUtils.isEmpty((String)url) && url.toLowerCase().startsWith("https");
    }

    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList = null;
        String keyStoreFilepwd = this.getCredential(this.mKeyStoreURL, this.mKeyStoreAlias);
        kmList = this.getKeyManagers(this.mKeyStoreFile, keyStoreFilepwd);
        return kmList;
    }

    public KeyManager[] getKeyManagers(String keyStoreFile, String keyStoreFilePwd) {
        KeyManager[] kmList;
        block12: {
            kmList = null;
            if (StringUtils.isNotEmpty((String)keyStoreFile) && StringUtils.isNotEmpty((String)keyStoreFilePwd)) {
                InputStream in = null;
                try {
                    in = this.getFileInputStream(keyStoreFile);
                    if (in != null) {
                        KeyStore keyStore = KeyStore.getInstance(this.mKeyStoreType);
                        keyStore.load(in, keyStoreFilePwd.toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(RANGER_SSL_KEYMANAGER_ALGO_TYPE);
                        keyManagerFactory.init(keyStore, keyStoreFilePwd.toCharArray());
                        kmList = keyManagerFactory.getKeyManagers();
                        break block12;
                    }
                    LOG.error("Unable to obtain keystore from file [" + keyStoreFile + "]");
                    throw new IllegalStateException("Unable to find keystore file :" + keyStoreFile);
                }
                catch (KeyStoreException e) {
                    LOG.error("Unable to obtain from KeyStore :" + e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("Unable to init keystore:" + e.getMessage(), e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error("SSL algorithm is NOT available in the environment", (Throwable)e);
                    throw new IllegalStateException("SSL algorithm is NOT available in the environment :" + e.getMessage(), e);
                }
                catch (CertificateException e) {
                    LOG.error("Unable to obtain the requested certification ", (Throwable)e);
                    throw new IllegalStateException("Unable to obtain the requested certification :" + e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    LOG.error("Unable to find the necessary SSL Keystore Files", (Throwable)e);
                    throw new IllegalStateException("Unable to find keystore file :" + keyStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (IOException e) {
                    LOG.error("Unable to read the necessary SSL Keystore Files", (Throwable)e);
                    throw new IllegalStateException("Unable to read keystore file :" + keyStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (UnrecoverableKeyException e) {
                    LOG.error("Unable to recover the key from keystore", (Throwable)e);
                    throw new IllegalStateException("Unable to recover the key from keystore :" + keyStoreFile + ", error :" + e.getMessage(), e);
                }
                finally {
                    this.close(in, keyStoreFile);
                }
            }
        }
        return kmList;
    }

    private TrustManager[] getTrustManagers() {
        String trustStoreFilepwd;
        TrustManager[] tmList = null;
        if (StringUtils.isNotEmpty((String)this.mTrustStoreURL) && StringUtils.isNotEmpty((String)this.mTrustStoreAlias) && StringUtils.isNotEmpty((String)(trustStoreFilepwd = this.getCredential(this.mTrustStoreURL, this.mTrustStoreAlias)))) {
            tmList = this.getTrustManagers(this.mTrustStoreFile, trustStoreFilepwd);
        }
        return tmList;
    }

    public TrustManager[] getTrustManagers(String trustStoreFile, String trustStoreFilepwd) {
        TrustManager[] tmList;
        block11: {
            tmList = null;
            if (StringUtils.isNotEmpty((String)trustStoreFile) && StringUtils.isNotEmpty((String)trustStoreFilepwd)) {
                InputStream in = null;
                try {
                    in = this.getFileInputStream(trustStoreFile);
                    if (in != null) {
                        KeyStore trustStore = KeyStore.getInstance(this.mTrustStoreType);
                        trustStore.load(in, trustStoreFilepwd.toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(RANGER_SSL_TRUSTMANAGER_ALGO_TYPE);
                        trustManagerFactory.init(trustStore);
                        tmList = trustManagerFactory.getTrustManagers();
                        break block11;
                    }
                    LOG.error("Unable to obtain truststore from file [" + trustStoreFile + "]");
                    throw new IllegalStateException("Unable to find truststore file :" + trustStoreFile);
                }
                catch (KeyStoreException e) {
                    LOG.error("Unable to obtain from KeyStore", (Throwable)e);
                    throw new IllegalStateException("Unable to init keystore:" + e.getMessage(), e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error("SSL algorithm is NOT available in the environment :" + e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("SSL algorithm is NOT available in the environment :" + e.getMessage(), e);
                }
                catch (CertificateException e) {
                    LOG.error("Unable to obtain the requested certification :" + e.getMessage(), (Throwable)e);
                    throw new IllegalStateException("Unable to obtain the requested certification :" + e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    LOG.error("Unable to find the necessary SSL TrustStore File:" + trustStoreFile, (Throwable)e);
                    throw new IllegalStateException("Unable to find trust store file :" + trustStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (IOException e) {
                    LOG.error("Unable to read the necessary SSL TrustStore Files :" + trustStoreFile, (Throwable)e);
                    throw new IllegalStateException("Unable to read the trust store file :" + trustStoreFile + ", error :" + e.getMessage(), e);
                }
                finally {
                    this.close(in, trustStoreFile);
                }
            }
        }
        return tmList;
    }

    protected SSLContext getSSLContext(KeyManager[] kmList, TrustManager[] tmList) {
        if (tmList == null) {
            try {
                String algo = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algo);
                tmf.init((KeyStore)null);
                tmList = tmf.getTrustManagers();
            }
            catch (IllegalStateException | KeyStoreException | NoSuchAlgorithmException e) {
                LOG.error("Unable to get the default SSL TrustStore for the JVM", (Throwable)e);
                tmList = null;
            }
        }
        Validate.notNull((Object)tmList, (String)"TrustManager is not specified");
        try {
            SSLContext sslContext = SSLContext.getInstance(RANGER_SSL_CONTEXT_ALGO_TYPE);
            sslContext.init(kmList, tmList, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("SSL algorithm is not available in the environment", (Throwable)e);
            throw new IllegalStateException("SSL algorithm is not available in the environment: " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            LOG.error("Unable to initialize the SSLContext", (Throwable)e);
            throw new IllegalStateException("Unable to initialize the SSLContext: " + e.getMessage(), e);
        }
    }

    private String getCredential(String url, String alias) {
        return RangerCredentialProvider.getInstance().getCredentialString(url, alias);
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (StringUtils.isNotEmpty((String)fileName)) {
            File f = new File(fileName);
            in = f.exists() ? new FileInputStream(f) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                LOG.error("Error while closing file: [" + filename + "]", (Throwable)excp);
            }
        }
    }

    public ClientResponse get(String relativeUrl, Map<String, String> params) throws Exception {
        ClientResponse finalResponse = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            int currentIndex = (startIndex + index) % this.configuredURLs.size();
            try {
                WebResource.Builder webResource = this.createWebResource(currentIndex, relativeUrl, params);
                finalResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).type("application/json")).get(ClientResponse.class);
                if (finalResponse == null) continue;
                if (finalResponse.getStatusInfo().getFamily() == Response.Status.Family.SERVER_ERROR) {
                    throw new ClientHandlerException("Response status: " + finalResponse.getStatus());
                }
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return finalResponse;
    }

    public ClientResponse get(String relativeUrl, Map<String, String> params, Cookie sessionId) throws Exception {
        ClientResponse finalResponse = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            int currentIndex = (startIndex + index) % this.configuredURLs.size();
            try {
                WebResource.Builder br = this.createWebResource(currentIndex, relativeUrl, params, sessionId);
                finalResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)br.accept(new String[]{"application/json"})).type("application/json")).get(ClientResponse.class);
                if (finalResponse == null) continue;
                if (finalResponse.getStatusInfo().getFamily() == Response.Status.Family.SERVER_ERROR) {
                    throw new ClientHandlerException("Response status: " + finalResponse.getStatus());
                }
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return finalResponse;
    }

    public ClientResponse post(String relativeUrl, Map<String, String> params, Object obj) throws Exception {
        ClientResponse finalResponse = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            int currentIndex = (startIndex + index) % this.configuredURLs.size();
            try {
                WebResource.Builder webResource = this.createWebResource(currentIndex, relativeUrl, params);
                finalResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).type("application/json")).post(ClientResponse.class, (Object)this.toJson(obj));
                if (finalResponse == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return finalResponse;
    }

    public ClientResponse post(String relativeURL, Map<String, String> params, Object obj, Cookie sessionId) throws Exception {
        ClientResponse response = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            int currentIndex = (startIndex + index) % this.configuredURLs.size();
            try {
                WebResource.Builder br = this.createWebResource(currentIndex, relativeURL, params, sessionId);
                response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)br.accept(new String[]{"application/json"})).type("application/json")).post(ClientResponse.class, (Object)this.toJson(obj));
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return response;
    }

    public ClientResponse delete(String relativeUrl, Map<String, String> params) throws Exception {
        ClientResponse finalResponse = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            int currentIndex = (startIndex + index) % this.configuredURLs.size();
            try {
                WebResource.Builder webResource = this.createWebResource(currentIndex, relativeUrl, params);
                finalResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).type("application/json")).delete(ClientResponse.class);
                if (finalResponse == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return finalResponse;
    }

    public ClientResponse delete(String relativeURL, Map<String, String> params, Cookie sessionId) throws Exception {
        ClientResponse response = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            int currentIndex = (startIndex + index) % this.configuredURLs.size();
            try {
                WebResource.Builder br = this.createWebResource(currentIndex, relativeURL, params, sessionId);
                response = (ClientResponse)br.delete(ClientResponse.class);
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return response;
    }

    public ClientResponse put(String relativeUrl, Map<String, String> params, Object obj) throws Exception {
        ClientResponse finalResponse = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            int currentIndex = (startIndex + index) % this.configuredURLs.size();
            try {
                WebResource.Builder webResource = this.createWebResource(currentIndex, relativeUrl, params);
                finalResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).type("application/json")).put(ClientResponse.class, (Object)this.toJson(obj));
                if (finalResponse == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return finalResponse;
    }

    public ClientResponse put(String relativeURL, Object request, Cookie sessionId) throws Exception {
        ClientResponse response = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int retryAttempt = 0;
        for (int index = 0; index < this.configuredURLs.size(); ++index) {
            int currentIndex = (startIndex + index) % this.configuredURLs.size();
            try {
                WebResource.Builder br = this.createWebResource(currentIndex, relativeURL, null, sessionId);
                response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)br.accept(new String[]{"application/json"})).type("application/json")).put(ClientResponse.class, (Object)this.toJson(request));
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException ex) {
                if (!this.shouldRetry(this.configuredURLs.get(currentIndex), index, retryAttempt, (Exception)((Object)ex))) continue;
                ++retryAttempt;
                index = -1;
            }
        }
        return response;
    }

    protected static WebResource setQueryParams(WebResource webResource, Map<String, String> params) {
        WebResource ret = webResource;
        if (webResource != null && params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                ret = ret.queryParam(entry.getKey(), entry.getValue());
            }
        }
        return ret;
    }

    protected void setLastKnownActiveUrlIndex(int lastKnownActiveUrlIndex) {
        this.lastKnownActiveUrlIndex = lastKnownActiveUrlIndex;
    }

    protected WebResource.Builder createWebResource(int currentIndex, String relativeURL, Map<String, String> params) {
        WebResource webResource = this.getClient().resource(this.configuredURLs.get(currentIndex) + relativeURL);
        webResource = RangerRESTClient.setQueryParams(webResource, params);
        return webResource.getRequestBuilder();
    }

    protected WebResource.Builder createWebResource(int currentIndex, String relativeURL, Map<String, String> params, Cookie sessionId) {
        if (sessionId == null) {
            return this.createWebResource(currentIndex, relativeURL, params);
        }
        WebResource webResource = this.getCookieAuthClient().resource(this.configuredURLs.get(currentIndex) + relativeURL);
        webResource = RangerRESTClient.setQueryParams(webResource, params);
        return (WebResource.Builder)webResource.getRequestBuilder().cookie(sessionId);
    }

    protected boolean shouldRetry(String currentUrl, int index, int retryAttemptCount, Exception ex) throws Exception {
        boolean ret;
        LOG.warn("Failed to communicate with Ranger Admin. URL: " + currentUrl + ". Error: " + ex.getMessage());
        boolean isLastUrl = index == this.configuredURLs.size() - 1;
        boolean bl = ret = isLastUrl && retryAttemptCount < this.maxRetryAttempts;
        if (ret) {
            LOG.warn("Waiting for " + this.retryIntervalMs + "ms before retry attempt #" + (retryAttemptCount + 1));
            try {
                Thread.sleep(this.retryIntervalMs);
            }
            catch (InterruptedException excp) {
                LOG.error("Failed while waiting to retry", (Throwable)excp);
            }
        } else if (isLastUrl) {
            LOG.error("Failed to communicate with all Ranger Admin's URL's : [ " + this.configuredURLs + " ]");
            throw ex;
        }
        return ret;
    }

    public int getLastKnownActiveUrlIndex() {
        return this.lastKnownActiveUrlIndex;
    }

    public List<String> getConfiguredURLs() {
        return this.configuredURLs;
    }

    public boolean isSSL() {
        return this.mIsSSL;
    }

    public void setSSL(boolean mIsSSL) {
        this.mIsSSL = mIsSSL;
    }

    protected void setClient(Client client) {
        this.client = client;
    }

    protected void setKeyStoreType(String mKeyStoreType) {
        this.mKeyStoreType = mKeyStoreType;
    }

    protected void setTrustStoreType(String mTrustStoreType) {
        this.mTrustStoreType = mTrustStoreType;
    }
}

