/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionActivityInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class TransparentDataEncryptionActivitiesInner {
    private TransparentDataEncryptionActivitiesService service;
    private SqlManagementClientImpl client;

    public TransparentDataEncryptionActivitiesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (TransparentDataEncryptionActivitiesService)retrofit.create(TransparentDataEncryptionActivitiesService.class);
        this.client = client;
    }

    public List<TransparentDataEncryptionActivityInner> listByConfiguration(String resourceGroupName, String serverName, String databaseName) {
        return (List)((ServiceResponse)this.listByConfigurationWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<TransparentDataEncryptionActivityInner>> listByConfigurationAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<List<TransparentDataEncryptionActivityInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByConfigurationWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<List<TransparentDataEncryptionActivityInner>> listByConfigurationAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByConfigurationWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<List<TransparentDataEncryptionActivityInner>>, List<TransparentDataEncryptionActivityInner>>(){

            public List<TransparentDataEncryptionActivityInner> call(ServiceResponse<List<TransparentDataEncryptionActivityInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<TransparentDataEncryptionActivityInner>>> listByConfigurationWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String transparentDataEncryptionName = "current";
        String apiVersion = "2014-04-01";
        return this.service.listByConfiguration(this.client.subscriptionId(), resourceGroupName, serverName, databaseName, "current", "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<TransparentDataEncryptionActivityInner>>>>(){

            public Observable<ServiceResponse<List<TransparentDataEncryptionActivityInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TransparentDataEncryptionActivitiesInner.this.listByConfigurationDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TransparentDataEncryptionActivityInner>> listByConfigurationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TransparentDataEncryptionActivityInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface TransparentDataEncryptionActivitiesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.TransparentDataEncryptionActivities listByConfiguration"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/{transparentDataEncryptionName}/operationResults")
        public Observable<Response<ResponseBody>> listByConfiguration(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="databaseName") String var4, @Path(value="transparentDataEncryptionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

