/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.common;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.List;
import java.util.Optional;
import org.apache.ratis.examples.arithmetic.cli.Arithmetic;
import org.apache.ratis.examples.common.SubCommandBase;
import org.apache.ratis.examples.filestore.cli.FileStore;
import org.apache.ratis.util.JavaUtils;

public final class Runner {
    private Runner() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("No command type specified: ");
            return;
        }
        List<SubCommandBase> commands = Runner.initializeCommands(args[0]);
        Runner runner = new Runner();
        if (commands == null) {
            System.err.println("Wrong command type: " + args[0]);
            return;
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        JCommander.Builder builder = JCommander.newBuilder().addObject(runner);
        commands.forEach(command -> builder.addCommand(JavaUtils.getClassSimpleName(command.getClass()).toLowerCase(), command, new String[0]));
        JCommander jc = builder.build();
        try {
            jc.parse(newArgs);
            Optional<SubCommandBase> selectedCommand = commands.stream().filter(command -> JavaUtils.getClassSimpleName(command.getClass()).equalsIgnoreCase(jc.getParsedCommand())).findFirst();
            if (selectedCommand.isPresent()) {
                selectedCommand.get().run();
            } else {
                jc.usage();
            }
        }
        catch (ParameterException exception) {
            System.err.println("Wrong parameters: " + exception.getMessage());
            jc.usage();
        }
    }

    private static List<SubCommandBase> initializeCommands(String command) {
        if (command.equalsIgnoreCase(JavaUtils.getClassSimpleName(FileStore.class))) {
            return FileStore.getSubCommands();
        }
        if (command.equalsIgnoreCase(JavaUtils.getClassSimpleName(Arithmetic.class))) {
            return Arithmetic.getSubCommands();
        }
        return null;
    }
}

