/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.statistics;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.statistics.FutureHolder;
import org.apache.rocketmq.common.statistics.StatisticsItem;
import org.apache.rocketmq.common.statistics.StatisticsItemPrinter;

public class StatisticsItemScheduledPrinter
extends FutureHolder {
    protected String name;
    protected StatisticsItemPrinter printer;
    protected ScheduledExecutorService executor;
    protected long interval;
    protected InitialDelay initialDelay;
    protected Valve valve;

    public StatisticsItemScheduledPrinter(String name, StatisticsItemPrinter printer, ScheduledExecutorService executor, InitialDelay initialDelay, long interval, Valve valve) {
        this.name = name;
        this.printer = printer;
        this.executor = executor;
        this.initialDelay = initialDelay;
        this.interval = interval;
        this.valve = valve;
    }

    public void schedule(final StatisticsItem statisticsItem) {
        ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (StatisticsItemScheduledPrinter.this.enabled()) {
                    StatisticsItemScheduledPrinter.this.printer.print(StatisticsItemScheduledPrinter.this.name, statisticsItem, new String[0]);
                }
            }
        }, this.getInitialDelay(), this.interval, TimeUnit.MILLISECONDS);
        this.addFuture(statisticsItem, future);
    }

    public void remove(StatisticsItem statisticsItem) {
        this.removeAllFuture(statisticsItem);
    }

    protected long getInitialDelay() {
        return this.initialDelay != null ? this.initialDelay.get() : 0L;
    }

    protected boolean enabled() {
        return this.valve != null ? this.valve.enabled() : false;
    }

    protected boolean printZeroLine() {
        return this.valve != null ? this.valve.printZeroLine() : false;
    }

    public static interface Valve {
        public boolean enabled();

        public boolean printZeroLine();
    }

    public static interface InitialDelay {
        public long get();
    }
}

