/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.export;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.data.LogData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.export.MultiLogExporter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.export.NoopLogExporter;

public interface LogExporter
extends Closeable {
    public static LogExporter composite(LogExporter ... exporters) {
        return LogExporter.composite(Arrays.asList(exporters));
    }

    public static LogExporter composite(Iterable<LogExporter> exporters) {
        ArrayList<LogExporter> exportersList = new ArrayList<LogExporter>();
        for (LogExporter exporter : exporters) {
            exportersList.add(exporter);
        }
        if (exportersList.isEmpty()) {
            return NoopLogExporter.getInstance();
        }
        if (exportersList.size() == 1) {
            return (LogExporter)exportersList.get(0);
        }
        return MultiLogExporter.create(exportersList);
    }

    public CompletableResultCode export(Collection<LogData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

