"use strict";
exports.zhCN = void 0;
var _index = require("./zh-CN/_lib/formatDistance.js");
var _index2 = require("./zh-CN/_lib/formatLong.js");
var _index3 = require("./zh-CN/_lib/formatRelative.js");
var _index4 = require("./zh-CN/_lib/localize.js");
var _index5 = require("./zh-CN/_lib/match.js");

/**
 * @category Locales
 * @summary Chinese Simplified locale.
 * @language Chinese Simplified
 * @iso-639-2 zho
 * @author Changyu Geng [@KingMario](https://github.com/KingMario)
 * @author Song Shuoyun [@fnlctrl](https://github.com/fnlctrl)
 * @author sabrinaM [@sabrinamiao](https://github.com/sabrinamiao)
 * @author Carney Wu [@cubicwork](https://github.com/cubicwork)
 * @author Terrence Lam [@skyuplam](https://github.com/skyuplam)
 */
const zhCN = (exports.zhCN = {
  code: "zh-CN",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
});
