/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.ws;

import io.vertx.core.MultiMap;
import io.vertx.core.http.WebSocket;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.common.http.HttpStatus;
import org.apache.servicecomb.foundation.vertx.http.AbstractHttpServletResponse;

public class VertxClientWebSocketResponseToHttpServletResponse
extends AbstractHttpServletResponse {
    private final WebSocket vertxClientWebSocket;
    private final HttpStatus httpStatus;

    public VertxClientWebSocketResponseToHttpServletResponse(WebSocket vertxClientWebSocket) {
        this.vertxClientWebSocket = vertxClientWebSocket;
        this.httpStatus = new HttpStatus(101, "Switching Protocols");
    }

    @Override
    public int getStatus() {
        return this.httpStatus.getStatusCode();
    }

    @Override
    public Response.StatusType getStatusType() {
        return this.httpStatus;
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        MultiMap headers = this.vertxClientWebSocket.headers();
        if (headers == null) {
            return null;
        }
        return headers.get(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        MultiMap headers = this.vertxClientWebSocket.headers();
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers.getAll(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        MultiMap headers = this.vertxClientWebSocket.headers();
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers.names();
    }

    public WebSocket getVertxClientWebSocket() {
        return this.vertxClientWebSocket;
    }
}

