/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.zipkin2.reporter.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.shade.zipkin2.reporter.BytesMessageSender;
import org.apache.shardingsphere.shade.zipkin2.reporter.Call;
import org.apache.shardingsphere.shade.zipkin2.reporter.Callback;
import org.apache.shardingsphere.shade.zipkin2.reporter.CheckResult;
import org.apache.shardingsphere.shade.zipkin2.reporter.Encoding;
import org.apache.shardingsphere.shade.zipkin2.reporter.Sender;
import org.apache.shardingsphere.shade.zipkin2.reporter.internal.Platform;

public abstract class SenderAdapter
extends Sender {
    protected abstract BytesMessageSender delegate();

    @Override
    public final int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.delegate().messageSizeInBytes(encodedSpans);
    }

    @Override
    public final int messageSizeInBytes(int encodedSizeInBytes) {
        return this.delegate().messageSizeInBytes(encodedSizeInBytes);
    }

    @Override
    public final Encoding encoding() {
        return this.delegate().encoding();
    }

    @Override
    public final int messageMaxBytes() {
        return this.delegate().messageMaxBytes();
    }

    @Override
    @Deprecated
    public final Call<Void> sendSpans(List<byte[]> encodedSpans) {
        return new SendSpans(encodedSpans);
    }

    @Override
    public final void send(List<byte[]> encodedSpans) throws IOException {
        this.delegate().send(encodedSpans);
    }

    @Override
    @Deprecated
    public final CheckResult check() {
        try {
            this.delegate().send(Collections.<byte[]>emptyList());
            return CheckResult.OK;
        }
        catch (Throwable e) {
            Call.propagateIfFatal(e);
            return CheckResult.failed(e);
        }
    }

    @Override
    public final void close() {
        try {
            this.delegate().close();
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    public final String toString() {
        return this.delegate().toString();
    }

    final class SendSpans
    extends Call.Base<Void> {
        private final List<byte[]> encodedSpans;

        SendSpans(List<byte[]> encodedSpans) {
            this.encodedSpans = encodedSpans;
        }

        @Override
        protected Void doExecute() throws IOException {
            SenderAdapter.this.send(this.encodedSpans);
            return null;
        }

        @Override
        protected void doEnqueue(Callback<Void> callback) {
            try {
                SenderAdapter.this.send(this.encodedSpans);
                callback.onSuccess(null);
            }
            catch (Throwable t) {
                Call.propagateIfFatal(t);
                callback.onError(t);
            }
        }

        @Override
        public Call<Void> clone() {
            return new SendSpans(this.encodedSpans);
        }
    }
}

