/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.algorithm.core.processor;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;

public abstract class AlgorithmChangedProcessor<T extends RuleConfiguration>
implements RuleItemConfigurationChangedProcessor<T, AlgorithmConfiguration> {
    private final Class<? extends ShardingSphereRule> ruleClass;

    public final AlgorithmConfiguration swapRuleItemConfiguration(AlterRuleItem alterRuleItem, String yamlContent) {
        return new YamlAlgorithmConfigurationSwapper().swapToObject((YamlAlgorithmConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlAlgorithmConfiguration.class));
    }

    public final T findRuleConfiguration(ShardingSphereDatabase database) {
        return (T)database.getRuleMetaData().findSingleRule(this.ruleClass).map(ShardingSphereRule::getConfiguration).orElseGet(this::createEmptyRuleConfiguration);
    }

    public final void changeRuleItemConfiguration(AlterRuleItem alterRuleItem, T currentRuleConfig, AlgorithmConfiguration toBeChangedItemConfig) {
        this.getAlgorithmConfigurations(currentRuleConfig).put(((AlterNamedRuleItem)alterRuleItem).getItemName(), toBeChangedItemConfig);
    }

    public final void dropRuleItemConfiguration(DropRuleItem dropRuleItem, T currentRuleConfig) {
        this.getAlgorithmConfigurations(currentRuleConfig).remove(((DropNamedRuleItem)dropRuleItem).getItemName());
    }

    protected abstract T createEmptyRuleConfiguration();

    protected abstract Map<String, AlgorithmConfiguration> getAlgorithmConfigurations(T var1);

    @Generated
    public AlgorithmChangedProcessor(Class<? extends ShardingSphereRule> ruleClass) {
        this.ruleClass = ruleClass;
    }
}

