/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.connection.cursor;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CursorStatementContext;
import org.apache.shardingsphere.infra.session.connection.cursor.FetchGroup;

public final class CursorConnectionContext
implements AutoCloseable {
    private final Map<String, List<FetchGroup>> orderByValueGroups = new ConcurrentHashMap<String, List<FetchGroup>>();
    private final Map<String, Long> minGroupRowCounts = new ConcurrentHashMap<String, Long>();
    private final Map<String, CursorStatementContext> cursorStatementContexts = new ConcurrentHashMap<String, CursorStatementContext>();
    private final Map<String, Boolean> executedAllDirections = new ConcurrentHashMap<String, Boolean>();

    public void removeCursor(String cursorName) {
        this.orderByValueGroups.remove(cursorName);
        this.minGroupRowCounts.remove(cursorName);
        this.cursorStatementContexts.remove(cursorName);
        this.executedAllDirections.remove(cursorName);
    }

    @Override
    public void close() {
        this.orderByValueGroups.clear();
        this.minGroupRowCounts.clear();
        this.cursorStatementContexts.clear();
        this.executedAllDirections.clear();
    }

    @Generated
    public Map<String, List<FetchGroup>> getOrderByValueGroups() {
        return this.orderByValueGroups;
    }

    @Generated
    public Map<String, Long> getMinGroupRowCounts() {
        return this.minGroupRowCounts;
    }

    @Generated
    public Map<String, CursorStatementContext> getCursorStatementContexts() {
        return this.cursorStatementContexts;
    }

    @Generated
    public Map<String, Boolean> getExecutedAllDirections() {
        return this.executedAllDirections;
    }
}

