/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;

public final class PipelineContextManager {
    private static final Map<PipelineContextKey, PipelineContext> CONTEXT_MAP = new ConcurrentHashMap<PipelineContextKey, PipelineContext>();

    public static PipelineContext getContext(PipelineContextKey key) {
        return CONTEXT_MAP.get(key);
    }

    public static PipelineContext getProxyContext() {
        return CONTEXT_MAP.get(new PipelineContextKey(InstanceType.PROXY));
    }

    public static void putContext(PipelineContextKey key, PipelineContext context) {
        CONTEXT_MAP.put(key, context);
    }

    public static void removeContext(PipelineContextKey key) {
        CONTEXT_MAP.remove(key);
    }

    @Generated
    private PipelineContextManager() {
    }
}

