/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.insert;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.token.comparator.InsertSelectColumnsEncryptorComparator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.PreviousSQLTokensAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.UseDefaultInsertColumnsToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;

public final class EncryptInsertDefaultColumnsTokenGenerator
implements OptionalSQLTokenGenerator<InsertStatementContext>,
PreviousSQLTokensAware {
    private final EncryptRule rule;
    private List<SQLToken> previousSQLTokens;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !((InsertStatementContext)sqlStatementContext).containsInsertColumns();
    }

    public UseDefaultInsertColumnsToken generateSQLToken(InsertStatementContext insertStatementContext) {
        String tableName = insertStatementContext.getSqlStatement().getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        Optional<UseDefaultInsertColumnsToken> previousSQLToken = this.findInsertColumnsToken();
        if (previousSQLToken.isPresent()) {
            this.processPreviousSQLToken(previousSQLToken.get(), insertStatementContext, tableName);
            return previousSQLToken.get();
        }
        return this.generateNewSQLToken(insertStatementContext, tableName);
    }

    private Optional<UseDefaultInsertColumnsToken> findInsertColumnsToken() {
        for (SQLToken each : this.previousSQLTokens) {
            if (!(each instanceof UseDefaultInsertColumnsToken)) continue;
            return Optional.of((UseDefaultInsertColumnsToken)each);
        }
        return Optional.empty();
    }

    private void processPreviousSQLToken(UseDefaultInsertColumnsToken previousSQLToken, InsertStatementContext insertStatementContext, String tableName) {
        List<String> columnNames = this.getColumnNames(insertStatementContext, this.rule.getEncryptTable(tableName), previousSQLToken.getColumns());
        previousSQLToken.getColumns().clear();
        previousSQLToken.getColumns().addAll(columnNames);
    }

    private UseDefaultInsertColumnsToken generateNewSQLToken(InsertStatementContext insertStatementContext, String tableName) {
        Optional insertColumnsSegment = insertStatementContext.getSqlStatement().getInsertColumns();
        Preconditions.checkState((boolean)insertColumnsSegment.isPresent());
        if (null != insertStatementContext.getInsertSelectContext()) {
            Collection derivedInsertColumns = insertStatementContext.getSqlStatement().getDerivedInsertColumns();
            List projections = insertStatementContext.getInsertSelectContext().getSelectStatementContext().getProjectionsContext().getExpandProjections();
            ShardingSpherePreconditions.checkState((derivedInsertColumns.size() == projections.size() ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Column count doesn't match value count."));
            ShardingSpherePreconditions.checkState((boolean)InsertSelectColumnsEncryptorComparator.isSame(derivedInsertColumns, projections, this.rule), () -> new UnsupportedSQLOperationException("Can not use different encryptor in insert select columns"));
        }
        QuoteCharacter quoteCharacter = new DatabaseTypeRegistry(insertStatementContext.getDatabaseType()).getDialectDatabaseMetaData().getQuoteCharacter();
        return new UseDefaultInsertColumnsToken(((InsertColumnsSegment)insertColumnsSegment.get()).getStopIndex(), this.getColumnNames(insertStatementContext, this.rule.getEncryptTable(tableName), insertStatementContext.getColumnNames()), quoteCharacter);
    }

    private List<String> getColumnNames(InsertStatementContext sqlStatementContext, EncryptTable encryptTable, List<String> currentColumnNames) {
        LinkedList<String> result = new LinkedList<String>(currentColumnNames);
        Iterator descendingColumnNames = sqlStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            if (!encryptTable.isEncryptColumn(columnName)) continue;
            EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
            int columnIndex = result.indexOf(columnName);
            this.setCipherColumn(result, encryptColumn, columnIndex);
            if (encryptColumn.getAssistedQuery().isPresent()) {
                this.addAssistedQueryColumn(result, encryptColumn, columnIndex);
                ++columnIndex;
            }
            if (!encryptColumn.getLikeQuery().isPresent()) continue;
            this.addLikeQueryColumn(result, encryptColumn, columnIndex);
        }
        return result;
    }

    private void setCipherColumn(List<String> columnNames, EncryptColumn encryptColumn, int columnIndex) {
        columnNames.set(columnIndex, encryptColumn.getCipher().getName());
    }

    private void addAssistedQueryColumn(List<String> columnNames, EncryptColumn encryptColumn, int columnIndex) {
        encryptColumn.getAssistedQuery().ifPresent(optional -> columnNames.add(columnIndex + 1, optional.getName()));
    }

    private void addLikeQueryColumn(List<String> columnNames, EncryptColumn encryptColumn, int columnIndex) {
        encryptColumn.getLikeQuery().ifPresent(optional -> columnNames.add(columnIndex + 1, optional.getName()));
    }

    @Generated
    public EncryptInsertDefaultColumnsTokenGenerator(EncryptRule rule) {
        this.rule = rule;
    }

    @Generated
    public void setPreviousSQLTokens(List<SQLToken> previousSQLTokens) {
        this.previousSQLTokens = previousSQLTokens;
    }
}

