/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;

public final class MySQLTextResultSetRowPacket
extends MySQLPacket {
    private static final int NULL = 251;
    private final Collection<Object> data;

    public MySQLTextResultSetRowPacket(MySQLPacketPayload payload, int columnCount) {
        this.data = new ArrayList<Object>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            this.data.add(payload.readStringLenenc());
        }
    }

    @Override
    protected void write(MySQLPacketPayload payload) {
        for (Object each : this.data) {
            if (null == each) {
                payload.writeInt1(251);
                continue;
            }
            this.writeDataIntoPayload(payload, each);
        }
    }

    private void writeDataIntoPayload(MySQLPacketPayload payload, Object data) {
        if (data instanceof byte[]) {
            payload.writeBytesLenenc((byte[])data);
        } else if (data instanceof Timestamp && 0 == ((Timestamp)data).getNanos()) {
            payload.writeStringLenenc(data.toString().split("\\.")[0]);
        } else if (data instanceof BigDecimal) {
            payload.writeStringLenenc(((BigDecimal)data).toPlainString());
        } else if (data instanceof Boolean) {
            byte[] byArray;
            if (((Boolean)data).booleanValue()) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            payload.writeBytesLenenc(byArray);
        } else if (data instanceof LocalDateTime) {
            payload.writeStringLenenc(DateTimeFormatterFactory.getStandardFormatter().format((LocalDateTime)data));
        } else {
            payload.writeStringLenenc(data.toString());
        }
    }

    @Generated
    public MySQLTextResultSetRowPacket(Collection<Object> data) {
        this.data = data;
    }

    @Generated
    public Collection<Object> getData() {
        return this.data;
    }
}

