/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;

public final class LocalTransactionManager {
    private final ProxyDatabaseConnectionManager databaseConnectionManager;

    public void begin() {
        this.databaseConnectionManager.getConnectionPostProcessors().add(target -> target.setAutoCommit(false));
    }

    public void commit() throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        if (this.databaseConnectionManager.getConnectionSession().getConnectionContext().getTransactionContext().isExceptionOccur()) {
            exceptions.addAll(this.rollbackConnections());
        } else {
            exceptions.addAll(this.commitConnections());
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    private Collection<SQLException> commitConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.databaseConnectionManager.getCachedConnections().values()) {
            try {
                each.commit();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    public void rollback() throws SQLException {
        if (this.databaseConnectionManager.getConnectionSession().getTransactionStatus().isInTransaction()) {
            LinkedList<SQLException> exceptions = new LinkedList<SQLException>(this.rollbackConnections());
            this.throwSQLExceptionIfNecessary(exceptions);
        }
    }

    private Collection<SQLException> rollbackConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.databaseConnectionManager.getCachedConnections().values()) {
            try {
                each.rollback();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    private void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        Iterator<SQLException> iterator = exceptions.iterator();
        SQLException firstException = iterator.next();
        while (iterator.hasNext()) {
            firstException.setNextException(iterator.next());
        }
        throw firstException;
    }

    @Generated
    public LocalTransactionManager(ProxyDatabaseConnectionManager databaseConnectionManager) {
        this.databaseConnectionManager = databaseConnectionManager;
    }
}

