/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.util.Iterator;
import java.util.function.Function;
import org.springframework.integration.util.CloseableIterator;
import org.springframework.lang.Nullable;

public class FunctionIterator<T, V>
implements CloseableIterator<V> {
    private final AutoCloseable closeable;
    private final Iterator<T> iterator;
    private final Function<? super T, ? extends V> function;

    public FunctionIterator(Iterable<T> iterable, Function<? super T, ? extends V> function2) {
        this(null, iterable.iterator(), function2);
    }

    public FunctionIterator(@Nullable AutoCloseable closeable, Iterable<T> iterable, Function<? super T, ? extends V> function2) {
        this(closeable, iterable.iterator(), function2);
    }

    public FunctionIterator(Iterator<T> newIterator, Function<? super T, ? extends V> function2) {
        this(null, newIterator, function2);
    }

    public FunctionIterator(@Nullable AutoCloseable closeable, Iterator<T> newIterator, Function<? super T, ? extends V> function2) {
        this.closeable = closeable;
        this.iterator = newIterator;
        this.function = function2;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public V next() {
        return this.function.apply(this.iterator.next());
    }

    @Override
    public void close() {
        if (this.iterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.iterator)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

