/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.referencing.operation.builder.LocalizationGridException;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.base.AxisType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.GridCacheKey;
import org.apache.sis.storage.netcdf.base.GridCacheValue;
import org.apache.sis.storage.netcdf.base.Linearizer;
import org.apache.sis.storage.netcdf.base.NamedElement;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public final class Axis
extends NamedElement {
    public final char abbreviation;
    final AxisDirection direction;
    final int[] gridDimensionIndices;
    private final int[] gridSizes;
    final Variable coordinates;

    Axis(Variable coordinates) {
        this.coordinates = coordinates;
        this.abbreviation = AxisType.abbreviation(coordinates, true);
        AxisDirection dir = Axis.direction(coordinates.getUnitsString());
        this.direction = dir != null ? dir : AxisDirections.fromAbbreviation((char)this.abbreviation);
        this.gridDimensionIndices = null;
        this.gridSizes = null;
    }

    public Axis(char abbreviation, String direction, int[] gridDimensionIndices, int[] gridSizes, int dimension, Variable coordinates) throws IOException, DataStoreException {
        gridDimensionIndices = ArraysExt.resize((int[])gridDimensionIndices, (int)dimension);
        gridSizes = ArraysExt.resize((int[])gridSizes, (int)dimension);
        AxisDirection dir = (AxisDirection)Types.forCodeName(AxisDirection.class, (String)direction, null);
        AxisDirection check = AxisDirections.fromAbbreviation((char)abbreviation);
        boolean isSigned = dir != null;
        boolean isConsistent = true;
        if (dir == null) {
            dir = check;
        } else if (check != null) {
            isConsistent = AxisDirections.isColinear((AxisDirection)dir, (AxisDirection)check);
        }
        if (isConsistent) {
            check = Axis.direction(coordinates.getUnitsString());
            if (dir == null) {
                dir = check;
            } else if (check != null) {
                isConsistent = AxisDirections.isColinear((AxisDirection)dir, (AxisDirection)check);
            }
        }
        if (!isConsistent) {
            coordinates.warning(Grid.class, "getAxes", null, (short)9, coordinates.getFilename(), coordinates.getName(), dir, check);
            if (isSigned) {
                if (AxisDirections.isOpposite((AxisDirection)dir)) {
                    check = AxisDirections.opposite((AxisDirection)check);
                }
                dir = check;
            }
        }
        this.direction = dir;
        this.abbreviation = abbreviation;
        this.gridDimensionIndices = gridDimensionIndices;
        this.gridSizes = gridSizes;
        this.coordinates = coordinates;
        if (coordinates.getAttributeType("_FillValue") != null) {
            int page = this.getSizeProduct(1);
            Vector data = coordinates.read();
            int n = data.size();
            while (--n >= 0 && data.isNaN(n)) {
            }
            int nr = JDK18.ceilDiv((int)(++n), (int)page);
            assert (nr <= gridSizes[0]) : nr;
            gridSizes[0] = nr;
            assert (this.getSizeProduct(0) == n) : n;
        }
    }

    public static AxisDirection direction(String unit) {
        if (unit != null) {
            int s = unit.indexOf(95);
            if (s < 0) {
                s = unit.indexOf(32);
            }
            if (s > 0) {
                String direction = unit.substring(s + 1);
                if (direction.length() == 1) {
                    switch (Character.toUpperCase(direction.charAt(0))) {
                        case 'E': {
                            return AxisDirection.EAST;
                        }
                        case 'N': {
                            return AxisDirection.NORTH;
                        }
                    }
                }
                return (AxisDirection)Types.forCodeName(AxisDirection.class, (String)direction, null);
            }
        }
        return null;
    }

    final void mainDimensionFirst(Axis[] axes, int count) throws IOException, DataStoreException {
        int d0 = this.gridDimensionIndices[0];
        int d1 = this.gridDimensionIndices[1];
        boolean s = false;
        for (int i = 0; i < count; ++i) {
            int[] other = axes[i].gridDimensionIndices;
            if (other.length == 0) continue;
            int first = other[0];
            if (first == d1) {
                return;
            }
            boolean bl = s = first == d0;
            if (s) break;
        }
        if (!s) {
            int[] x = Axis.sampleIndices(this.gridSizes[0]);
            int[] y = Axis.sampleIndices(this.gridSizes[1]);
            double xInc = 0.0;
            double yInc = 0.0;
            int c = x.length * y.length;
            while (--c >= 0) {
                int i = x[c % y.length];
                int j = y[c / y.length];
                double vo = this.coordinates.coordinateForAxis(i, j);
                xInc += this.coordinates.coordinateForAxis(i + 1, j) - vo;
                yInc += this.coordinates.coordinateForAxis(i, j + 1) - vo;
            }
            if (!(Math.abs(yInc) > Math.abs(xInc))) {
                return;
            }
        }
        ArraysExt.swap((int[])this.gridSizes, (int)0, (int)1);
        ArraysExt.swap((int[])this.gridDimensionIndices, (int)0, (int)1);
    }

    private static int[] sampleIndices(int length) {
        int up;
        if (length >= 0) {
            if (length <= 1) {
                return ArraysExt.EMPTY_INT;
            }
            if (length <= 4) {
                return ArraysExt.range((int)0, (int)(length - 1));
            }
            up = length - 2;
        } else {
            up = 0x7FFFFFFE;
        }
        return new int[]{0, length >>> 1, up};
    }

    private int getMainDirection() {
        return this.getNumDimensions() < 2 || this.gridDimensionIndices[0] <= this.gridDimensionIndices[1] ? 0 : 1;
    }

    final int getNumDimensions() {
        return this.gridDimensionIndices != null ? this.gridDimensionIndices.length : this.coordinates.getNumDimensions();
    }

    private int getSizeProduct(int i) {
        int length = 1;
        while (i < this.gridSizes.length) {
            length = Math.multiplyExact(length, this.getSize(i++));
        }
        return length;
    }

    private int getSize(int i) {
        int n = this.gridSizes[i];
        if (n >= 0) {
            return n;
        }
        throw new ArithmeticException(this.coordinates.errors().getString((short)91, (Object)32));
    }

    public final OptionalLong getMainSize() {
        int m = this.getMainDirection();
        if (this.gridSizes != null && this.gridSizes.length > m) {
            return OptionalLong.of(Integer.toUnsignedLong(this.gridSizes[m]));
        }
        List<Dimension> dimensions = this.coordinates.getGridDimensions();
        if (dimensions.size() > m) {
            return OptionalLong.of(dimensions.get(m).length());
        }
        return OptionalLong.empty();
    }

    @Override
    public final String getName() {
        return this.coordinates.getName().trim();
    }

    public final Unit<?> getUnit() {
        return this.coordinates.getUnit();
    }

    final boolean isSameUnitAndDirection(CoordinateSystemAxis axis) {
        if (!axis.getDirection().equals((Object)this.direction)) {
            return false;
        }
        Unit<?> unit = this.getUnit();
        return unit == null || axis.getUnit().equals(unit);
    }

    final boolean isWraparound() {
        if (this.abbreviation == '\u0000') {
            return AxisDirections.absolute((AxisDirection)this.direction) == AxisDirection.EAST && Units.isAngular(this.getUnit());
        }
        return this.abbreviation == '\u03bb';
    }

    private double wraparoundRange() {
        if (this.isWraparound()) {
            double period = 360.0;
            Unit<?> unit = this.getUnit();
            if (unit != null) {
                try {
                    period = unit.getConverterToAny(Units.DEGREE).convert(period);
                }
                catch (IncommensurableException e) {
                    this.warning((Exception)((Object)e), (short)87, unit);
                    return Double.NaN;
                }
            }
            return period;
        }
        return Double.NaN;
    }

    final boolean isCellCorner() throws IOException, DataStoreException {
        boolean wraparound;
        double min;
        switch (this.abbreviation) {
            case '\u03bb': {
                min = -180.0;
                wraparound = true;
                break;
            }
            case '\u03c6': {
                min = -90.0;
                wraparound = false;
                break;
            }
            default: {
                return false;
            }
        }
        Vector data = this.read();
        int size = data.size();
        if (size != 0) {
            Unit unit = this.getUnit();
            if (unit == null) {
                unit = Units.DEGREE;
            }
            try {
                UnitConverter uc = unit.getConverterToAny(Units.DEGREE);
                if (wraparound && uc.convert(data.doubleValue(size - 1)) > 180.0) {
                    min = 0.0;
                }
                return uc.convert(data.doubleValue(0)) == min;
            }
            catch (IncommensurableException e) {
                this.warning((Exception)((Object)e), (short)87, unit);
            }
        }
        return false;
    }

    final CoordinateSystemAxis toISO(CSFactory factory, int order, boolean grid) throws DataStoreException, FactoryException, IOException {
        AxisDirection dir;
        Unit unit;
        String alt;
        String name = this.getName();
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", name);
        ArrayList<NamedIdentifier> aliases = new ArrayList<NamedIdentifier>(2);
        String standardName = this.coordinates.getAttributeAsString("standard_name");
        if (standardName != null) {
            NamedIdentifier std = new NamedIdentifier((Citation)Citations.NETCDF, (CharSequence)standardName);
            if (standardName.equals(name)) {
                properties.put("name", std);
            } else {
                aliases.add(std);
            }
        }
        if ((alt = this.coordinates.getAttributeAsString("long_name")) != null && !Axis.similar(alt, name)) {
            properties.put("description", alt);
            if (!Axis.similar(alt, standardName)) {
                aliases.add(new NamedIdentifier(null, (CharSequence)alt));
            }
        }
        if (!aliases.isEmpty()) {
            properties.put("alias", aliases.toArray(GenericName[]::new));
        }
        if ((unit = this.getUnit()) == null) {
            switch (this.abbreviation) {
                case '\u03a9': 
                case '\u03b8': 
                case '\u03bb': 
                case '\u03c6': {
                    unit = Units.DEGREE;
                    break;
                }
                case 'D': 
                case 'E': 
                case 'H': 
                case 'N': 
                case 'h': 
                case 'r': {
                    unit = Units.METRE;
                    break;
                }
                case 't': {
                    unit = Units.SECOND;
                    break;
                }
                case 'x': 
                case 'y': {
                    Vector values;
                    Number increment;
                    if (grid && (increment = (values = this.read()).increment(0.0)) != null && increment.doubleValue() == 1.0) {
                        unit = Units.PIXEL;
                        break;
                    }
                }
                default: {
                    unit = Units.UNITY;
                }
            }
        }
        if ((dir = this.direction) == null) {
            if (Units.isTemporal((Unit)unit)) {
                dir = AxisDirection.FUTURE;
            } else if (Units.isPressure((Unit)unit)) {
                dir = AxisDirection.UP;
            } else {
                switch (order) {
                    case 0: {
                        dir = AxisDirection.COLUMN_POSITIVE;
                        break;
                    }
                    case 1: {
                        dir = AxisDirection.ROW_POSITIVE;
                        break;
                    }
                    default: {
                        dir = AxisDirections.UNSPECIFIED;
                    }
                }
            }
        }
        Object abbr = this.abbreviation != '\u0000' ? Character.toString(this.abbreviation).intern() : (dir != null && unit != null ? AxisDirections.suggestAbbreviation((String)name, (AxisDirection)dir, (Unit)unit) : "A" + (order + 1));
        return factory.createCoordinateSystemAxis(properties, (String)abbr, dir, unit);
    }

    final boolean trySetTransform(Matrix gridToCRS, int lastSrcDim, int tgtDim, List<MathTransform> nonLinears) throws IOException, DataStoreException {
        switch (this.getNumDimensions()) {
            case 0: {
                Vector data = this.read();
                if (!data.isEmpty()) {
                    gridToCRS.setElement(tgtDim, gridToCRS.getNumCol() - 1, data.doubleValue(0));
                }
                return true;
            }
            case 1: {
                Vector data = this.read();
                int srcDim = lastSrcDim - this.gridDimensionIndices[0];
                if (this.coordinates.trySetTransform(gridToCRS, srcDim, tgtDim, data)) {
                    return true;
                }
                nonLinears.add((MathTransform)MathTransforms.interpolate(null, (double[])data.doubleValues()));
                return false;
            }
            case 2: {
                Vector data = this.read();
                int[] repetitions = data.repetitions(this.gridSizes);
                long repetitionLength = 1L;
                for (int r : repetitions) {
                    repetitionLength = Math.multiplyExact(repetitionLength, r);
                }
                int ri = this.getMainDirection();
                for (int i = 0; i <= 1; ++i) {
                    int step;
                    int length;
                    int width = this.getSize(ri ^ i);
                    int height = this.getSize(ri ^ i ^ 1);
                    if (repetitionLength % (long)width != 0L) continue;
                    if (repetitions.length >= 2) {
                        length = height;
                        step = width;
                    } else {
                        length = width;
                        step = 1;
                    }
                    data = data.subSampling(0, step, length);
                    if (this.coordinates.trySetTransform(gridToCRS, lastSrcDim - i, tgtDim, data)) {
                        return true;
                    }
                    nonLinears.add((MathTransform)MathTransforms.interpolate(null, (double[])data.doubleValues()));
                    return false;
                }
                break;
            }
        }
        nonLinears.add(null);
        return false;
    }

    final GridCacheValue createLocalizationGrid(Axis other) throws IOException, FactoryException, TransformException, DataStoreException {
        int yd;
        int yo;
        if (this.getNumDimensions() != 2 || other.getNumDimensions() != 2) {
            return null;
        }
        int xo = other.gridDimensionIndices[0];
        int xd = this.gridDimensionIndices[0];
        if ((xo != xd | (yo = other.gridDimensionIndices[1]) != (yd = this.gridDimensionIndices[1])) & (xo != yd | yo != xd)) {
            return null;
        }
        int ri = xd <= yd ? 0 : 1;
        int ro = xo <= yo ? 0 : 1;
        int width = this.getSize(ri ^ 1);
        int height = this.getSize(ri);
        if (other.gridSizes[ro ^ 1] != width || other.gridSizes[ro] != height) {
            this.warning(null, (short)102, this.getName(), other.getName());
            return null;
        }
        GridCacheKey keyLocal = new GridCacheKey(width, height, this, other);
        Decoder decoder = this.coordinates.decoder;
        GridCacheValue tr = keyLocal.cached(decoder);
        if (tr != null) {
            return tr;
        }
        long time = System.nanoTime();
        Vector vx = this.read();
        Vector vy = other.read();
        Set<Linearizer> linearizers = decoder.convention().linearizers(decoder);
        GridCacheKey.Global keyGlobal = new GridCacheKey.Global(keyLocal, vx, vy, linearizers);
        Cache.Handler<GridCacheValue> handler = keyGlobal.lock();
        try {
            tr = (GridCacheValue)handler.peek();
            if (tr == null) {
                LocalizationGridBuilder grid = new LocalizationGridBuilder(width, height);
                grid.setControlPoints(new Vector[]{vx, vy});
                double period = this.wraparoundRange();
                if (!Double.isNaN(period)) {
                    grid.resolveWraparoundAxis(0, ri, period);
                }
                if (!Double.isNaN(period = other.wraparoundRange())) {
                    grid.resolveWraparoundAxis(1, ro, period);
                }
                MathTransformFactory factory = decoder.getMathTransformFactory();
                if (!linearizers.isEmpty()) {
                    Linearizer.setCandidatesOnGrid(new Axis[]{this, other}, linearizers, grid);
                }
                grid.setDesiredPrecision(0.001);
                tr = new GridCacheValue(linearizers, grid, factory);
                tr = keyLocal.cache(decoder, tr);
            }
        }
        catch (LocalizationGridException ex) {
            for (Linearizer linearizer : linearizers) {
                InternationalString reason = linearizer.getPotentialCause();
                if (reason == null) continue;
                ex.setPotentialCause((CharSequence)reason);
                break;
            }
            throw ex;
        }
        finally {
            handler.putAndUnlock((Object)tr);
        }
        decoder.performance(Grid.class, "getGridGeometry", (short)22, time);
        return tr;
    }

    private void warning(Exception exception, short key, Object ... arguments) {
        this.coordinates.error(Variable.class, "getGridGeometry", exception, key, arguments);
    }

    final Vector read() throws IOException, DataStoreException {
        TransferFunction tr = this.coordinates.getTransferFunction();
        if (tr.getType() == TransferFunctionType.LINEAR) {
            Vector data = this.coordinates.read();
            if (this.gridSizes != null) {
                data = data.subList(0, this.getSizeProduct(0));
            }
            data = data.transform(tr.getScale(), tr.getOffset());
            return data;
        }
        throw new DataStoreException(this.coordinates.decoder.resources().getString((short)18, this.getName()));
    }

    public boolean equals(Object other) {
        if (other instanceof Axis) {
            Axis that = (Axis)other;
            return that.abbreviation == this.abbreviation && that.direction == this.direction && Arrays.equals(that.gridDimensionIndices, this.gridDimensionIndices) && Arrays.equals(that.gridSizes, this.gridSizes) && this.coordinates.equals(that.coordinates);
        }
        return false;
    }

    public int hashCode() {
        return this.abbreviation + Arrays.hashCode(this.gridDimensionIndices) + Arrays.hashCode(this.gridSizes);
    }
}

