/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.xml.bind.gml.TemporalAdapter;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalDatumType")
@XmlRootElement(name="TemporalDatum")
public class DefaultTemporalDatum
extends AbstractDatum
implements TemporalDatum {
    private static final long serialVersionUID = -1507650596130032757L;
    @XmlSchemaType(name="dateTime")
    @XmlElement(name="origin", required=true)
    @XmlJavaTypeAdapter(value=TemporalAdapter.class)
    private Temporal origin;

    public DefaultTemporalDatum(Map<String, ?> properties, Temporal origin) {
        super(properties);
        this.origin = origin;
    }

    @Deprecated(since="1.5")
    public DefaultTemporalDatum(Map<String, ?> properties, Date origin) {
        this(properties, TemporalDate.toTemporal((Date)origin));
    }

    protected DefaultTemporalDatum(TemporalDatum datum) {
        super((Datum)datum);
        this.origin = TemporalDate.toTemporal((Date)datum.getOrigin());
    }

    public static DefaultTemporalDatum castOrCopy(TemporalDatum object) {
        return object == null || object instanceof DefaultTemporalDatum ? (DefaultTemporalDatum)object : new DefaultTemporalDatum(object);
    }

    public Class<? extends TemporalDatum> getInterface() {
        return TemporalDatum.class;
    }

    public Date getOrigin() {
        return TemporalDate.toDate((Temporal)this.origin);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                return Objects.equals(this.origin, ((DefaultTemporalDatum)object).origin);
            }
        }
        return Objects.equals(this.getOrigin(), ((TemporalDatum)object).getOrigin());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.origin);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String name = super.formatTo(formatter);
        if (name != null) {
            formatter.setInvalidWKT(this, null);
            return name;
        }
        formatter.append(new Origin(TemporalDate.toTemporal((Date)this.getOrigin())));
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return formatter.shortOrLong("TDatum", "TimeDatum");
    }

    private DefaultTemporalDatum() {
    }

    private static final class Origin
    extends FormattableObject {
        private final Temporal origin;

        Origin(Temporal origin) {
            this.origin = origin;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.append(this.origin);
            return "TimeOrigin";
        }
    }
}

