/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.awt.image.DataBuffer;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.coverage.IllegalSampleDimensionException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.internal.shared.RangeArgument;
import org.apache.sis.image.internal.shared.RasterFactory;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.NumberType;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreResource;
import org.apache.sis.storage.netcdf.base.DataType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Raster;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.storage.netcdf.base.VariableRole;
import org.apache.sis.storage.netcdf.internal.Resources;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;

public final class RasterResource
extends AbstractGridCoverageResource
implements StoreResource {
    private static final String[] VECTOR_COMPONENT_NAMES = new String[]{"eastward", "westward", "northward", "southward", "upward", "downward"};
    private GenericName identifier;
    private final GridGeometry gridGeometry;
    private final SampleDimension[] sampleDimensions;
    private final Variable[] data;
    private final int bandDimension;
    private final int visibleBand;
    private final Path location;
    private final DataStore lock;

    private RasterResource(Decoder decoder, String name, GridGeometry grid, List<Variable> bands, int numBands, int bandDim, DataStore lock) {
        super(decoder.listeners, false);
        this.lock = lock;
        this.gridGeometry = grid;
        this.bandDimension = bandDim;
        this.location = decoder.location;
        this.identifier = decoder.nameFactory.createLocalName(decoder.namespace, (CharSequence)name);
        this.visibleBand = decoder.convention().getVisibleBand();
        this.sampleDimensions = new SampleDimension[numBands];
        this.data = (Variable[])bands.toArray(Variable[]::new);
        assert (this.data.length == (this.bandDimension >= 0 ? 1 : this.sampleDimensions.length));
    }

    public static List<Resource> create(Decoder decoder, DataStore lock) throws IOException, DataStoreException {
        boolean changed;
        assert (Thread.holdsLock(lock));
        Variable[] variables = (Variable[])decoder.getVariables().clone();
        ArrayList<Variable> siblings = new ArrayList<Variable>(4);
        ArrayList<Resource> resources = new ArrayList<Resource>(variables.length);
        HashMap<GenericName, List<RasterResource>> byName = new HashMap<GenericName, List<RasterResource>>();
        for (int i = 0; i < variables.length; ++i) {
            int numBands;
            int bandDimension;
            GridGeometry grid;
            Variable variable = variables[i];
            if (!VariableRole.isCoverage(variable) || (grid = variable.getGridGeometry()) == null) continue;
            siblings.add(variable);
            String name = variable.getStandardName();
            List<Dimension> gridDimensions = variable.getGridDimensions();
            int dataDimension = gridDimensions.size();
            int gridDimension = grid.getDimension();
            if (dataDimension != gridDimension) {
                bandDimension = variable.bandDimension;
                Dimension dim = gridDimensions.get(dataDimension - 1 - bandDimension);
                numBands = Math.toIntExact(dim.length());
                if (dataDimension != gridDimension + 1 || bandDimension > 0 && bandDimension != gridDimension) {
                    throw new DataStoreContentException(Resources.forLocale(decoder.listeners.getLocale()).getString((short)19, name, decoder.getFilename(), dataDimension, gridDimension));
                }
            } else {
                bandDimension = -1;
                DataType type = variable.getDataType();
                for (String keyword : VECTOR_COMPONENT_NAMES) {
                    int prefixLength = name.indexOf(keyword);
                    if (prefixLength < 0) continue;
                    int suffixStart = prefixLength + keyword.length();
                    int suffixLength = name.length() - suffixStart;
                    int j = i;
                    block2: while (++j < variables.length) {
                        Variable candidate = variables[j];
                        if (!VariableRole.isCoverage(candidate)) {
                            variables[j] = null;
                            continue;
                        }
                        String cn = candidate.getStandardName();
                        if (!cn.regionMatches(cn.length() - suffixLength, name, suffixStart, suffixLength) || !cn.regionMatches(0, name, 0, prefixLength) || candidate.getDataType() != type || !grid.equals((Object)candidate.getGridGeometry())) continue;
                        for (String k : VECTOR_COMPONENT_NAMES) {
                            if (!cn.startsWith(k, prefixLength)) continue;
                            siblings.add(candidate);
                            variables[j] = null;
                            continue block2;
                        }
                    }
                    if (siblings.size() <= 1) continue;
                    if (suffixLength != 0) {
                        int c = name.codePointAt(suffixStart);
                        if (prefixLength != 0 ? c == name.codePointBefore(prefixLength) : c == 95) {
                            suffixStart += Character.charCount(c);
                        }
                    }
                    name = new StringBuilder(name).delete(prefixLength, suffixStart).toString();
                }
                numBands = siblings.size();
            }
            RasterResource r = new RasterResource(decoder, name.trim(), grid, siblings, numBands, bandDimension, lock);
            r.addToNameMap(byName);
            resources.add((Resource)r);
            siblings.clear();
        }
        do {
            changed = false;
            List collisions = null;
            Iterator it = byName.values().iterator();
            while (it.hasNext()) {
                List rs = (List)it.next();
                if (rs.size() < 2) continue;
                it.remove();
                if (collisions == null) {
                    collisions = rs;
                    continue;
                }
                collisions.addAll(rs);
            }
            if (collisions == null) continue;
            for (RasterResource r : collisions) {
                changed |= r.resolveNameCollision(decoder);
                r.addToNameMap(byName);
            }
        } while (changed);
        return resources;
    }

    private void addToNameMap(Map<GenericName, List<RasterResource>> byName) {
        byName.computeIfAbsent(this.identifier, key -> new ArrayList()).add(this);
    }

    private boolean resolveNameCollision(Decoder decoder) {
        LocalName newValue;
        String name = null;
        for (Variable v : this.data) {
            name = (String)CharSequences.commonWords(name, (CharSequence)v.getName());
        }
        if (Strings.isNullOrEmpty(name)) {
            name = this.data[0].getName();
        }
        if ((newValue = decoder.nameFactory.createLocalName(decoder.namespace, (CharSequence)name)).equals((Object)this.identifier)) {
            return false;
        }
        this.identifier = newValue;
        return true;
    }

    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder metadata = new MetadataBuilder();
        String title = null;
        for (Variable v : this.data) {
            title = (String)CharSequences.commonWords((CharSequence)title, (CharSequence)v.getDescription());
            metadata.addIdentifier((CharSequence)v.getGroupName(), v.getName(), MetadataBuilder.Scope.RESOURCE);
        }
        if (title != null && !title.isEmpty()) {
            metadata.addTitle((CharSequence)CharSequences.camelCaseToSentence((CharSequence)title).toString());
        }
        metadata.addDefaultMetadata((AbstractGridCoverageResource)this, this.listeners);
        return metadata.build();
    }

    public Optional<GenericName> getIdentifier() {
        return Optional.of(this.identifier);
    }

    public GridGeometry getGridGeometry() {
        return this.gridGeometry;
    }

    private Variable getVariable(int i) {
        return this.data[this.bandDimension >= 0 ? 0 : i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        SampleDimension.Builder builder = null;
        try {
            DataStore dataStore = this.lock;
            synchronized (dataStore) {
                for (int i = 0; i < this.sampleDimensions.length; ++i) {
                    if (this.sampleDimensions[i] != null) continue;
                    if (builder == null) {
                        builder = new SampleDimension.Builder();
                    }
                    this.sampleDimensions[i] = this.createSampleDimension(builder, this.getVariable(i), i);
                    builder.clear();
                }
            }
        }
        catch (RuntimeException e) {
            throw new DataStoreContentException((Throwable)e);
        }
        return Containers.viewAsUnmodifiableList((Object[])this.sampleDimensions);
    }

    private SampleDimension createSampleDimension(SampleDimension.Builder builder, Variable band, int index) {
        SampleDimension sd;
        NumberRange range;
        if (!RasterResource.createEnumeration(builder, band) && (range = band.getValidRange()) != null) {
            try {
                MathTransform1D mt = band.getTransferFunction().getTransform();
                if (!mt.isIdentity() && range instanceof MeasurementRange) {
                    MathTransform1D inverse = mt.inverse();
                    boolean isMinIncluded = range.isMinIncluded();
                    boolean isMaxIncluded = range.isMaxIncluded();
                    double minimum = inverse.transform(range.getMinDouble());
                    double maximum = inverse.transform(range.getMaxDouble());
                    if (maximum < minimum) {
                        double swap = maximum;
                        maximum = minimum;
                        minimum = swap;
                        boolean sb = isMaxIncluded;
                        isMaxIncluded = isMinIncluded;
                        isMinIncluded = sb;
                    }
                    range = !band.getDataType().number.isWiderThan(NumberType.LONG) && minimum >= -9.223372036854776E18 && maximum <= 9.223372036854776E18 ? NumberRange.create((long)Math.round(minimum), (boolean)isMinIncluded, (long)Math.round(maximum), (boolean)isMaxIncluded) : NumberRange.create((double)minimum, (boolean)isMinIncluded, (double)maximum, (boolean)isMaxIncluded);
                }
                if (range.isEmpty()) {
                    band.warning(RasterResource.class, "getSampleDimensions", null, (short)16, band.getFilename(), band.getName(), range.getMinValue(), range.getMaxValue());
                } else {
                    String name = band.getDescription();
                    if (name == null) {
                        name = band.getName();
                    }
                    if (band.getRole() == VariableRole.DISCRETE_COVERAGE) {
                        builder.addQualitative((CharSequence)name, range);
                    } else {
                        builder.addQuantitative((CharSequence)name, range, mt, band.getUnit());
                    }
                }
            }
            catch (TransformException e) {
                this.listeners.warning((Exception)((Object)e));
            }
        }
        boolean setBackground = true;
        int missingValueOrdinal = 0;
        int ordinal = band.hasRealValues() ? 0 : -1;
        for (Map.Entry<Number, Object> entry : band.getNodataValues().entrySet()) {
            Object name;
            Number n = ordinal >= 0 ? (Number)Float.valueOf(MathFunctions.toNanFloat((int)ordinal++)) : (Number)entry.getKey();
            Object label = entry.getValue();
            if (label instanceof Integer) {
                boolean isFill = setBackground && ((Integer)label & 1) != 0;
                name = Vocabulary.formatInternational((short)(isFill ? (short)83 : 135));
                if (isFill) {
                    setBackground = false;
                    builder.setBackground((CharSequence)name, n);
                    continue;
                }
                if (++missingValueOrdinal >= 2) {
                    name = name.toString() + " #" + missingValueOrdinal;
                }
            } else {
                name = (CharSequence)label;
            }
            builder.addQualitative((CharSequence)name, n, n);
        }
        String name = band.getName();
        if (this.bandDimension >= 0) {
            name = Strings.toIndexed((String)name, (int)index);
        }
        builder.setName((CharSequence)name);
        try {
            sd = builder.build();
        }
        catch (IllegalSampleDimensionException e) {
            builder.categories().clear();
            sd = builder.build();
            this.listeners.warning((Exception)((Object)e));
        }
        return sd;
    }

    private static boolean createEnumeration(SampleDimension.Builder builder, Variable band) {
        Map<Long, String> enumeration = band.getEnumeration();
        if (enumeration == null) {
            return false;
        }
        for (Map.Entry<Long, String> entry : enumeration.entrySet()) {
            Long value = entry.getKey();
            CharSequence name = entry.getValue();
            if (name == null) {
                name = Vocabulary.formatInternational((short)208);
            }
            builder.addQualitative(name, (Number)value, (Number)value);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        DataBuffer imageBuffer;
        GridGeometry targetDomain;
        long startTime = System.nanoTime();
        RangeArgument rangeIndices = RangeArgument.validate((int)this.sampleDimensions.length, (int[])ranges, (Localized)this.listeners);
        Variable first = this.data[this.bandDimension >= 0 ? 0 : rangeIndices.getFirstSpecified()];
        DataType dataType = first.getDataType();
        if (this.bandDimension < 0) {
            for (int i = 0; i < rangeIndices.getNumBands(); ++i) {
                Variable variable = this.data[rangeIndices.getSourceIndex(i)];
                if (dataType.equals((Object)variable.getDataType())) continue;
                throw new DataStoreContentException(Resources.forLocale(this.listeners.getLocale()).getString((short)13, this.getFilename(), first.getName(), variable.getName()));
            }
        }
        Object[] bands = new SampleDimension[rangeIndices.getNumBands()];
        int[] bandOffsets = null;
        try {
            GridDerivation targetGeometry = this.gridGeometry.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(domain != null ? domain : this.gridGeometry);
            GridExtent areaOfInterest = targetGeometry.getIntersection();
            long[] subsampling = targetGeometry.getSubsampling();
            int numBuffers = bands.length;
            targetDomain = targetGeometry.build();
            if (this.bandDimension >= 0) {
                areaOfInterest = rangeIndices.insertBandDimension(areaOfInterest, this.bandDimension);
                subsampling = rangeIndices.insertSubsampling(subsampling, this.bandDimension);
                if (this.bandDimension == 0) {
                    bandOffsets = new int[numBuffers];
                }
                numBuffers = 1;
            }
            Buffer[] sampleValues = new Buffer[numBuffers];
            DataStore dataStore = this.lock;
            synchronized (dataStore) {
                for (int i = 0; i < bands.length; ++i) {
                    int indexInResource = rangeIndices.getSourceIndex(i);
                    int indexInRaster = rangeIndices.getTargetIndex(i);
                    Variable variable = this.getVariable(indexInResource);
                    SampleDimension b = this.sampleDimensions[indexInResource];
                    if (b == null) {
                        this.sampleDimensions[indexInResource] = b = this.createSampleDimension(rangeIndices.builder(), variable, i);
                    }
                    bands[indexInRaster] = b;
                    if (bandOffsets != null) {
                        bandOffsets[indexInRaster] = i;
                        indexInRaster = 0;
                    }
                    if (i >= numBuffers) continue;
                    try {
                        sampleValues[indexInRaster] = (Buffer)variable.read(areaOfInterest, subsampling).buffer().get();
                        continue;
                    }
                    catch (ArithmeticException e) {
                        throw variable.canNotComputePosition(e);
                    }
                }
            }
            if (this.bandDimension > 0) {
                int stride = Math.toIntExact(this.data[0].getBandStride());
                Buffer values = sampleValues[0].limit(stride);
                sampleValues = new Buffer[bands.length];
                for (int i = 0; i < sampleValues.length; ++i) {
                    if (i != 0) {
                        values = values.duplicate();
                        int p = values.limit();
                        values.position(p).limit(Math.addExact(p, stride));
                    }
                    sampleValues[i] = values;
                }
            }
            imageBuffer = RasterFactory.wrap((org.apache.sis.image.DataType)dataType.rasterDataType, (Buffer[])sampleValues);
        }
        catch (IOException | RuntimeException e) {
            throw this.canNotRead(this.getFilename(), domain, e);
        }
        if (imageBuffer == null) {
            throw new DataStoreContentException(Errors.forLocale((Locale)this.listeners.getLocale()).getString((short)200, (Object)dataType.name()));
        }
        Variable main = this.data[this.visibleBand];
        Raster raster = new Raster(targetDomain, Containers.viewAsUnmodifiableList((Object[])bands), imageBuffer, rangeIndices.getPixelStride(), bandOffsets, this.visibleBand, main.decoder.convention().getColors(main));
        this.logReadOperation(this.location, targetDomain, startTime);
        return raster;
    }

    private String getFilename() {
        return this.location != null ? this.location.getFileName().toString() : this.listeners.getSourceName();
    }

    public final Optional<Resource.FileSet> getFileSet() {
        return this.location != null ? Optional.of(new Resource.FileSet(this.location)) : Optional.empty();
    }

    public final DataStore getOriginator() {
        return this.lock;
    }

    protected final Object getSynchronizationLock() {
        return this.lock;
    }

    public String toString() {
        return Strings.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"identifier", this.identifier});
    }
}

