/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.logging;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.logging.LoggingDecoratorBuilder;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

abstract class AbstractLoggingClientBuilder
extends LoggingDecoratorBuilder {
    private Sampler<? super ClientRequestContext> successSampler = Sampler.always();
    private Sampler<? super ClientRequestContext> failureSampler = Sampler.always();

    AbstractLoggingClientBuilder() {
    }

    public AbstractLoggingClientBuilder sampler(Sampler<? super ClientRequestContext> sampler) {
        Objects.requireNonNull(sampler, "sampler");
        this.successSampler = sampler;
        this.failureSampler = sampler;
        return this;
    }

    public AbstractLoggingClientBuilder samplingRate(float samplingRate) {
        Preconditions.checkArgument(0.0 <= (double)samplingRate && (double)samplingRate <= 1.0, "samplingRate: %s (expected: 0.0 <= samplingRate <= 1.0)", (Object)Float.valueOf(samplingRate));
        return this.sampler(Sampler.random(samplingRate));
    }

    @UnstableApi
    public AbstractLoggingClientBuilder failureSampler(Sampler<? super ClientRequestContext> failureSampler) {
        this.failureSampler = Objects.requireNonNull(failureSampler, "failureSampler");
        return this;
    }

    final Sampler<? super ClientRequestContext> failureSampler() {
        return this.failureSampler;
    }

    @UnstableApi
    public AbstractLoggingClientBuilder failureSamplingRate(float failureSamplingRate) {
        Preconditions.checkArgument(0.0 <= (double)failureSamplingRate && (double)failureSamplingRate <= 1.0, "failureSamplingRate: %s (expected: 0.0 <= failureSamplingRate <= 1.0)", (Object)Float.valueOf(failureSamplingRate));
        return this.failureSampler(Sampler.random(failureSamplingRate));
    }

    @UnstableApi
    public AbstractLoggingClientBuilder successSampler(Sampler<? super ClientRequestContext> successSampler) {
        this.successSampler = Objects.requireNonNull(successSampler, "successSampler");
        return this;
    }

    final Sampler<? super ClientRequestContext> successSampler() {
        return this.successSampler;
    }

    @UnstableApi
    public AbstractLoggingClientBuilder successSamplingRate(float successSamplingRate) {
        Preconditions.checkArgument(0.0 <= (double)successSamplingRate && (double)successSamplingRate <= 1.0, "successSamplingRate: %s (expected: 0.0 <= successSamplingRate <= 1.0)", (Object)Float.valueOf(successSamplingRate));
        return this.successSampler(Sampler.random(successSamplingRate));
    }
}

