/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.logging.JsonLogFormatter;
import com.linecorp.armeria.common.logging.JsonLogFormatterBuilder;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.TextLogFormatter;
import com.linecorp.armeria.common.logging.TextLogFormatterBuilder;

@UnstableApi
public interface LogFormatter {
    public static LogFormatter ofText() {
        return TextLogFormatter.DEFAULT_INSTANCE;
    }

    public static TextLogFormatterBuilder builderForText() {
        return new TextLogFormatterBuilder();
    }

    public static LogFormatter ofJson() {
        return JsonLogFormatter.DEFAULT_INSTANCE;
    }

    public static LogFormatter ofJson(ObjectMapper objectMapper) {
        return new JsonLogFormatterBuilder().objectMapper(objectMapper).build();
    }

    public static JsonLogFormatterBuilder builderForJson() {
        return new JsonLogFormatterBuilder();
    }

    public String formatRequest(RequestOnlyLog var1);

    public String formatResponse(RequestLog var1);
}

