/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.util.Set;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.ShareFetchMetricsManager;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;

public class ShareFetchMetricsAggregator {
    private final ShareFetchMetricsManager shareFetchMetricsManager;
    private final FetchMetrics fetchMetrics = new FetchMetrics();
    private final Set<TopicPartition> unrecordedPartitions;

    public ShareFetchMetricsAggregator(ShareFetchMetricsManager shareFetchMetricsManager, Set<TopicPartition> partitions) {
        this.shareFetchMetricsManager = shareFetchMetricsManager;
        this.unrecordedPartitions = partitions;
    }

    public void record(TopicPartition partition, int bytes, int records) {
        this.fetchMetrics.increment(bytes, records);
        this.maybeRecordMetrics(partition);
    }

    private void maybeRecordMetrics(TopicPartition partition) {
        this.unrecordedPartitions.remove(partition);
        if (!this.unrecordedPartitions.isEmpty()) {
            return;
        }
        this.shareFetchMetricsManager.recordRecordsFetched(this.fetchMetrics.records);
        this.shareFetchMetricsManager.recordBytesFetched(this.fetchMetrics.bytes);
    }

    private static class FetchMetrics {
        private int bytes;
        private int records;

        private FetchMetrics() {
        }

        private void increment(int bytes, int records) {
            this.bytes += bytes;
            this.records += records;
        }
    }
}

