/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.netty.http.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import java.net.InetSocketAddress;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.netty.http.common.AttributeKeys;
import org.apache.skywalking.apm.plugin.netty.http.config.NettyHttpPluginConfig;
import org.apache.skywalking.apm.plugin.netty.http.utils.HttpDataCollectUtils;
import org.apache.skywalking.apm.plugin.netty.http.utils.TypeUtils;

@ChannelHandler.Sharable
public class NettyHttpRequestEncoderTracingHandler
extends ChannelOutboundHandlerAdapter {
    private static final ILog LOGGER = LogManager.getLogger(NettyHttpRequestEncoderTracingHandler.class);

    public static NettyHttpRequestEncoderTracingHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private NettyHttpRequestEncoderTracingHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        try {
            if (!TypeUtils.isHttpRequest(msg)) {
                return;
            }
            AbstractSpan lastSpan = (AbstractSpan)ctx.channel().attr(AttributeKeys.HTTP_CLIENT_SPAN).getAndSet(null);
            if (null != lastSpan) {
                ContextManager.stopSpan((AbstractSpan)lastSpan);
            }
            HttpRequest request = (HttpRequest)msg;
            HttpHeaders headers = request.headers();
            String uri = request.uri();
            InetSocketAddress address = (InetSocketAddress)ctx.channel().remoteAddress();
            String peer = address.getHostString() + ":" + address.getPort();
            String url = peer + uri;
            ContextCarrier contextCarrier = new ContextCarrier();
            AbstractSpan span = ContextManager.createExitSpan((String)("Netty-http:" + uri), (ContextCarrier)contextCarrier, (String)peer);
            CarrierItem item = contextCarrier.items();
            while (item.hasNext()) {
                item = item.next();
                headers.add((CharSequence)AsciiString.of((CharSequence)item.getHeadKey()), (Object)item.getHeadValue());
            }
            ContextSnapshot contextSnapshot = (ContextSnapshot)ctx.channel().attr(AttributeKeys.CONTEXT_SNAPSHOT_ATTRIBUTE_KEY).get();
            if (contextSnapshot != null) {
                ContextManager.continued((ContextSnapshot)contextSnapshot);
            }
            span.prepareForAsync();
            SpanLayer.asHttp((AbstractSpan)span);
            span.setPeer(peer);
            span.setComponent((Component)ComponentsDefine.NETTY_HTTP);
            boolean sslFlag = ctx.channel().pipeline().context(SslHandler.class) != null;
            Tags.URL.set(span, sslFlag ? "https://" + url : "http://" + url);
            Tags.HTTP.METHOD.set(span, request.method().name());
            if (NettyHttpPluginConfig.Plugin.NettyHttp.COLLECT_REQUEST_BODY && TypeUtils.isLastHttpContent(msg)) {
                HttpDataCollectUtils.collectHttpRequestBody(request.headers(), ((LastHttpContent)msg).content(), span);
            }
            ContextManager.stopSpan((AbstractSpan)span);
            ctx.channel().attr(AttributeKeys.HTTP_CLIENT_SPAN).set((Object)span);
        }
        catch (Exception e) {
            LOGGER.error("Fail to trace netty http request", (Throwable)e);
        }
        finally {
            try {
                ctx.write(msg, promise);
            }
            catch (Throwable throwable) {
                AbstractSpan span = (AbstractSpan)ctx.channel().attr(AttributeKeys.HTTP_CLIENT_SPAN).getAndSet(null);
                if (span != null) {
                    span.errorOccurred();
                    span.log(throwable);
                    Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(500));
                    span.asyncFinish();
                }
                throw throwable;
            }
        }
    }

    private static class SingletonHolder {
        private static final NettyHttpRequestEncoderTracingHandler INSTANCE = new NettyHttpRequestEncoderTracingHandler();

        private SingletonHolder() {
        }
    }
}

