/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import org.apache.sling.installer.api.tasks.TaskResource;
import org.osgi.framework.Bundle;

public abstract class BundleUtil {
    private static final String ATTR_START = "sling.osgi.installer.start.bundle";

    public static void markBundleStart(TaskResource rsrc) {
        rsrc.setAttribute(ATTR_START, "true");
    }

    public static boolean isBundleStart(TaskResource rsrc) {
        return rsrc.getAttribute(ATTR_START) != null;
    }

    public static void clearBundleStart(TaskResource rsrc) {
        rsrc.setAttribute(ATTR_START, null);
    }

    public static boolean isSystemBundleFragment(Bundle installedBundle) {
        String fragmentHeader = BundleUtil.getFragmentHostHeader(installedBundle);
        return fragmentHeader != null && fragmentHeader.indexOf("extension") > 0;
    }

    public static boolean isBundleActive(Bundle b) {
        if (b.getState() == 32) {
            return true;
        }
        if (b.getState() == 8 && BundleUtil.isLazyActivatian(b)) {
            return true;
        }
        return BundleUtil.getFragmentHostHeader(b) != null;
    }

    public static String getFragmentHostHeader(Bundle b) {
        return (String)b.getHeaders("").get("Fragment-Host");
    }

    public static boolean isLazyActivatian(Bundle b) {
        return "lazy".equals(b.getHeaders("").get("Bundle-ActivationPolicy"));
    }
}

