/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.sightly.engine.BundledUnitManager;
import org.apache.sling.scripting.sightly.impl.engine.ExtensionRegistryService;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.apache.sling.scripting.sightly.impl.engine.bundled.BundledUnitManagerImpl;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SlingHTLMasterCompiler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ScriptEngineFactory.class}, property={"extensions=html", "names=htl", "names=HTL", "service.description=HTL Templating Engine", "compatible.javax.script.name=sly"})
public class SightlyScriptEngineFactory
extends AbstractScriptEngineFactory {
    public static final String SHORT_NAME = "sightly";
    public static final String EXTENSION = "html";
    private static final String LANGUAGE_NAME = "The HTL Templating Language";
    private static final String LANGUAGE_VERSION = "1.4";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile SlingHTLMasterCompiler slingHTLMasterCompiler;
    @Reference
    private ExtensionRegistryService extensionRegistryService;
    @Reference
    private SightlyEngineConfiguration configuration;
    @Reference
    private ScriptCache scriptCache;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private ServiceRegistration<BundledUnitManager> bundledUnitManagerServiceRegistration;
    private ServiceRegistration<BundledUnitManagerImpl> bundledUnitManagerImplServiceRegistration;
    private BundledUnitManagerImpl bundledUnitManager;

    public SightlyScriptEngineFactory() {
        this.setNames(new String[]{"htl", "HTL", SHORT_NAME});
        this.setExtensions(new String[]{EXTENSION});
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this.bundledUnitManager = new BundledUnitManagerImpl(this, this.scriptCache, this.resourceResolverFactory);
        this.bundledUnitManagerImplServiceRegistration = bundleContext.registerService(BundledUnitManagerImpl.class, (Object)this.bundledUnitManager, null);
        this.bundledUnitManagerServiceRegistration = bundleContext.registerService(BundledUnitManager.class, (Object)this.bundledUnitManager, null);
    }

    @Deactivate
    public void deactivate() {
        if (this.bundledUnitManagerServiceRegistration != null) {
            this.bundledUnitManagerServiceRegistration.unregister();
        }
        if (this.bundledUnitManagerImplServiceRegistration != null) {
            this.bundledUnitManagerImplServiceRegistration.unregister();
        }
    }

    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    public String getLanguageVersion() {
        return LANGUAGE_VERSION;
    }

    public ScriptEngine getScriptEngine() {
        return new SightlyScriptEngine(this, this.extensionRegistryService, this.slingHTLMasterCompiler, this.bundledUnitManager);
    }

    public SightlyEngineConfiguration getConfiguration() {
        return this.configuration;
    }
}

