/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.jackrabbit.oak.commons.json.JsonObject;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.query.stats.QueryRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryOptions {
    private static final Logger LOG = LoggerFactory.getLogger(QueryOptions.class);
    public Traversal traversal = Traversal.DEFAULT;
    public String indexName;
    public String indexTag;
    public Optional<Long> limit = Optional.empty();
    public Optional<Long> offset = Optional.empty();
    public List<String> prefetch = Collections.emptyList();
    public Optional<Integer> prefetchCount = Optional.empty();

    public QueryOptions() {
    }

    public QueryOptions(QueryOptions defaultValues) {
        this.traversal = defaultValues.traversal;
        this.indexName = defaultValues.indexName;
        this.indexTag = defaultValues.indexTag;
        this.limit = defaultValues.limit;
        this.offset = defaultValues.offset;
        this.prefetch = defaultValues.prefetch;
        this.prefetchCount = defaultValues.prefetchCount;
    }

    QueryOptions(JsonObject json) {
        Map<String, String> map = json.getProperties();
        String x = map.get("traversal");
        if (x != null) {
            this.traversal = Traversal.valueOf(x);
        }
        if ((x = map.get("indexName")) != null) {
            this.indexName = x;
        }
        if ((x = map.get("indexTag")) != null) {
            this.indexTag = x;
        }
        if ((x = map.get("limit")) != null) {
            try {
                this.limit = Optional.of(Long.parseLong(x));
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid limit {}", (Object)x);
            }
        }
        if ((x = map.get("prefetches")) != null) {
            try {
                this.prefetchCount = Optional.of(Integer.parseInt(x));
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid prefetch count {}", (Object)x);
            }
        }
        if ((x = map.get("prefetch")) != null) {
            ArrayList<String> list = new ArrayList<String>();
            JsopTokenizer t = new JsopTokenizer(x);
            t.read(91);
            do {
                list.add(t.readString());
            } while (t.matches(44));
            t.read(93);
            this.prefetch = list;
        }
    }

    public static class AutomaticQueryOptionsMapping {
        private final HashMap<String, QueryOptions> map = new HashMap();

        public AutomaticQueryOptionsMapping(String json) {
            try {
                JsonObject obj = JsonObject.fromJson(json, true);
                for (Map.Entry<String, JsonObject> e : obj.getChildren().entrySet()) {
                    String statement = e.getKey();
                    QueryOptions options = new QueryOptions(e.getValue());
                    String queryPattern = QueryRecorder.simplifySafely(statement);
                    this.map.put(queryPattern, options);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Can not parse {}", (Object)json, (Object)e);
            }
        }

        public QueryOptions getDefaultValues(String statement) {
            if (this.map.isEmpty()) {
                return new QueryOptions();
            }
            String queryPattern = QueryRecorder.simplifySafely(statement);
            return this.map.computeIfAbsent(queryPattern, v -> new QueryOptions());
        }
    }

    public static enum Traversal {
        OK,
        WARN,
        FAIL,
        DEFAULT;

    }
}

