/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.reports;

import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.mojos.reports.ReportContext;
import org.apache.sling.feature.maven.mojos.reports.Reporter;

public class ContentsReporter
implements Reporter {
    @Override
    public String getName() {
        return "contents";
    }

    @Override
    public void generateReport(ReportContext ctx) throws MojoExecutionException {
        TreeSet<ArtifactId> bundles = new TreeSet<ArtifactId>();
        TreeSet<ArtifactId> artifacts = new TreeSet<ArtifactId>();
        for (Feature feature : ctx.getFeatures()) {
            for (Artifact bundle : feature.getBundles()) {
                if (!ctx.matches(bundle.getId())) continue;
                bundles.add(bundle.getId());
            }
            for (Extension ext : feature.getExtensions()) {
                if (ext.getType() != ExtensionType.ARTIFACTS) continue;
                for (Artifact artifact : ext.getArtifacts()) {
                    if (!ctx.matches(artifact.getId())) continue;
                    artifacts.add(artifact.getId());
                }
            }
        }
        ArrayList<String> report = new ArrayList<String>();
        report.add("Bundles:");
        report.add("-------------------------------------------");
        bundles.stream().forEach(id -> report.add(id.toMvnId()));
        report.add("");
        report.add("Artifacts:");
        report.add("-------------------------------------------");
        artifacts.stream().forEach(id -> report.add(id.toMvnId()));
        ctx.addReport(this.getName().concat(".txt"), report);
    }
}

