% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R, R/stats.R
\name{corr}
\alias{corr}
\alias{corr,Column-method}
\alias{corr,SparkDataFrame-method}
\title{corr}
\usage{
corr(x, ...)

\S4method{corr}{Column}(x, col2)

\S4method{corr}{SparkDataFrame}(x, colName1, colName2, method = "pearson")
}
\arguments{
\item{x}{a Column or a SparkDataFrame.}

\item{...}{additional argument(s). If \code{x} is a Column, a Column
should be provided. If \code{x} is a SparkDataFrame, two column names should
be provided.}

\item{col2}{a (second) Column.}

\item{colName1}{the name of the first column}

\item{colName2}{the name of the second column}

\item{method}{Optional. A character specifying the method for calculating the correlation.
only "pearson" is allowed now.}
}
\value{
The Pearson Correlation Coefficient as a Double.
}
\description{
Computes the Pearson Correlation Coefficient for two Columns.
}
\note{
corr since 1.6.0

corr since 1.6.0
}
\examples{
\dontrun{
df <- createDataFrame(cbind(model = rownames(mtcars), mtcars))
head(select(df, corr(df$mpg, df$hp)))}

\dontrun{
corr(df, "mpg", "hp")
corr(df, "mpg", "hp", method = "pearson")}
}
\seealso{
Other aggregate functions: 
\code{\link{avg}()},
\code{\link{column_aggregate_functions}},
\code{\link{count}()},
\code{\link{cov}()},
\code{\link{first}()},
\code{\link{last}()}

Other stat functions: 
\code{\link{approxQuantile}()},
\code{\link{cov}()},
\code{\link{crosstab}()},
\code{\link{freqItems}()},
\code{\link{sampleBy}()}
}
\concept{aggregate functions}
\concept{stat functions}
