/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DeactivatedCheckpointCompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DeactivatedCheckpointIDCounter;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.slf4j.Logger;

public final class SchedulerUtils {
    private SchedulerUtils() {
        throw new UnsupportedOperationException("Instantiation of SchedulerUtils is not supported.");
    }

    public static CompletedCheckpointStore createCompletedCheckpointStoreIfCheckpointingIsEnabled(JobGraph jobGraph, Configuration configuration, ClassLoader userCodeLoader, CheckpointRecoveryFactory checkpointRecoveryFactory, Logger log) throws JobExecutionException {
        JobID jobId = jobGraph.getJobID();
        if (DefaultExecutionGraphBuilder.isCheckpointingEnabled(jobGraph)) {
            try {
                return SchedulerUtils.createCompletedCheckpointStore(configuration, userCodeLoader, checkpointRecoveryFactory, log, jobId);
            }
            catch (Exception e) {
                throw new JobExecutionException(jobId, "Failed to initialize high-availability completed checkpoint store", e);
            }
        }
        return DeactivatedCheckpointCompletedCheckpointStore.INSTANCE;
    }

    @VisibleForTesting
    static CompletedCheckpointStore createCompletedCheckpointStore(Configuration jobManagerConfig, ClassLoader classLoader, CheckpointRecoveryFactory recoveryFactory, Logger log, JobID jobId) throws Exception {
        int maxNumberOfCheckpointsToRetain = jobManagerConfig.getInteger(CheckpointingOptions.MAX_RETAINED_CHECKPOINTS);
        if (maxNumberOfCheckpointsToRetain <= 0) {
            log.warn("The setting for '{} : {}' is invalid. Using default value of {}", new Object[]{CheckpointingOptions.MAX_RETAINED_CHECKPOINTS.key(), maxNumberOfCheckpointsToRetain, CheckpointingOptions.MAX_RETAINED_CHECKPOINTS.defaultValue()});
            maxNumberOfCheckpointsToRetain = (Integer)CheckpointingOptions.MAX_RETAINED_CHECKPOINTS.defaultValue();
        }
        return recoveryFactory.createRecoveredCompletedCheckpointStore(jobId, maxNumberOfCheckpointsToRetain, classLoader);
    }

    public static CheckpointIDCounter createCheckpointIDCounterIfCheckpointingIsEnabled(JobGraph jobGraph, CheckpointRecoveryFactory checkpointRecoveryFactory) throws JobExecutionException {
        JobID jobId = jobGraph.getJobID();
        if (DefaultExecutionGraphBuilder.isCheckpointingEnabled(jobGraph)) {
            try {
                return SchedulerUtils.createCheckpointIdCounter(checkpointRecoveryFactory, jobId);
            }
            catch (Exception e) {
                throw new JobExecutionException(jobId, "Failed to initialize high-availability checkpoint id counter", e);
            }
        }
        return DeactivatedCheckpointIDCounter.INSTANCE;
    }

    private static CheckpointIDCounter createCheckpointIdCounter(CheckpointRecoveryFactory recoveryFactory, JobID jobId) throws Exception {
        return recoveryFactory.createCheckpointIDCounter(jobId);
    }
}

