/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.ooxml.GenericElementPptxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporterContext;

public class IconLabelElementPptxHandler
implements GenericElementPptxHandler {
    private static final IconLabelElementPptxHandler INSTANCE = new IconLabelElementPptxHandler();

    public static IconLabelElementPptxHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void exportElement(JRPptxExporterContext exporterContext, JRGenericPrintElement element) {
        JRPrintText labelPrintText = (JRPrintText)element.getParameterValue("labelTextElement");
        if (labelPrintText == null) {
            return;
        }
        JRBasePrintFrame frame = new JRBasePrintFrame(element.getDefaultStyleProvider());
        frame.setX(element.getX());
        frame.setY(element.getY());
        frame.setWidth(element.getWidth());
        frame.setHeight(element.getHeight());
        frame.setStyle(element.getStyle());
        frame.setBackcolor(element.getBackcolor());
        frame.setForecolor(element.getForecolor());
        frame.setMode(element.getMode());
        JRLineBox lineBox = (JRLineBox)element.getParameterValue("lineBox");
        if (lineBox != null) {
            frame.copyBox(lineBox);
        }
        frame.addElement(labelPrintText);
        JRPrintText iconPrintText = (JRPrintText)element.getParameterValue("iconTextElement");
        if (iconPrintText != null) {
            frame.addElement(iconPrintText);
        }
        try {
            JRPptxExporter exporter = (JRPptxExporter)exporterContext.getExporterRef();
            exporter.exportFrame(frame);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

