/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen.codegen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.iogen.ColIndexStructure;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.FormatIdentifyer;
import org.apache.sysds.runtime.iogen.MappingProperties;
import org.apache.sysds.runtime.iogen.RowIndexStructure;
import org.apache.sysds.runtime.iogen.codegen.CodeGenTrieNode;

public class CodeGenTrie {
    private final CustomProperties properties;
    private final CodeGenTrieNode ctnValue;
    private final CodeGenTrieNode ctnIndexes;
    private final String destination;
    private boolean isMatrix;
    private final FormatIdentifyer formatIdentifyer;

    public CodeGenTrie(CustomProperties properties, String destination, boolean isMatrix, FormatIdentifyer formatIdentifyer) {
        this.properties = properties;
        this.destination = destination;
        this.isMatrix = isMatrix;
        this.formatIdentifyer = formatIdentifyer;
        this.ctnValue = new CodeGenTrieNode(CodeGenTrieNode.NodeType.VALUE);
        this.ctnIndexes = new CodeGenTrieNode(CodeGenTrieNode.NodeType.INDEX);
        if (properties.getColKeyPatterns() != null) {
            for (int c = 0; c < properties.getColKeyPatterns().length; ++c) {
                Types.ValueType vt = Types.ValueType.FP64;
                if (!this.isMatrix) {
                    vt = properties.getSchema()[c];
                }
                this.insert(this.ctnValue, "" + c, vt, properties.getColKeyPatterns()[c]);
            }
        } else if (properties.getValueKeyPattern() != null) {
            this.insert(this.ctnValue, "col", Types.ValueType.FP64, properties.getValueKeyPattern());
        }
        if (properties.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.RowWiseExist || properties.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.CellWiseExist) {
            this.insert(this.ctnIndexes, "0", Types.ValueType.INT32, properties.getRowIndexStructure().getKeyPattern());
        }
        if (properties.getColIndexStructure().getProperties() == ColIndexStructure.IndexProperties.CellWiseExist && properties.getColIndexStructure().getKeyPattern() != null) {
            this.insert(this.ctnIndexes, "1", Types.ValueType.INT32, properties.getColIndexStructure().getKeyPattern());
        }
    }

    private void insert(CodeGenTrieNode root, String index, Types.ValueType valueType, ArrayList<String> keys) {
        CodeGenTrieNode currentNode = root;
        int rci = 0;
        for (String key : keys) {
            if (!currentNode.getChildren().containsKey(key)) break;
            currentNode = currentNode.getChildren().get(key);
            ++rci;
        }
        if (rci == keys.size()) {
            currentNode.setEndOfCondition(true);
            currentNode.setColIndex(index);
        } else {
            for (int i = rci; i < keys.size(); ++i) {
                CodeGenTrieNode newNode = new CodeGenTrieNode(i == keys.size() - 1, index, valueType, keys.get(i), new HashSet<String>(), root.getType());
                newNode.setRowIndexBeginPos(this.properties.getRowIndexStructure().getRowIndexBegin());
                newNode.setColIndexBeginPos(this.properties.getColIndexStructure().getColIndexBegin());
                currentNode.getChildren().put(keys.get(i), newNode);
                currentNode = newNode;
            }
        }
    }

    public String getJavaCode() {
        StringBuilder src = new StringBuilder();
        int ncols = this.properties.getNcols();
        MappingProperties.DataProperties data = this.properties.getMappingProperties().getDataProperties();
        RowIndexStructure.IndexProperties rowIndex = this.properties.getRowIndexStructure().getProperties();
        ColIndexStructure.IndexProperties colIndex = this.properties.getColIndexStructure().getProperties();
        if (data != MappingProperties.DataProperties.NOTEXIST && (rowIndex == RowIndexStructure.IndexProperties.Identity && colIndex == ColIndexStructure.IndexProperties.Identity || rowIndex == RowIndexStructure.IndexProperties.SeqScatter)) {
            this.getJavaCode(this.ctnValue, src, "0", true);
            src.append("row++; \n");
        } else if (rowIndex == RowIndexStructure.IndexProperties.CellWiseExist && colIndex == ColIndexStructure.IndexProperties.CellWiseExist) {
            this.getJavaCode(this.ctnIndexes, src, "0", false);
            src.append("if(col < " + ncols + "){ \n");
            if (data != MappingProperties.DataProperties.NOTEXIST) {
                this.getJavaCode(this.ctnValue, src, "0", false);
            } else {
                src.append(this.destination).append("(row, col, cellValue); \n");
            }
            src.append("} \n");
        } else if (rowIndex == RowIndexStructure.IndexProperties.Identity && colIndex == ColIndexStructure.IndexProperties.CellWiseExist) {
            src.append("String strValues[] = str.split(\"" + this.properties.getColIndexStructure().getValueDelim() + "\"); \n");
            src.append("for(String si: strValues){ \n");
            src.append("String strIndexValue[] = si.split(\"" + this.properties.getColIndexStructure().getIndexDelim() + "\", -1); \n");
            src.append("if(strIndexValue.length == 2){ \n");
            src.append("col = UtilFunctions.parseToInt(strIndexValue[0]); \n");
            src.append("if(col <= " + ncols + "){ \n");
            if (this.isMatrix) {
                src.append("try{ \n");
                src.append(this.destination).append("(row, col, Double.parseDouble(strIndexValue[1])); \n");
                src.append("lnnz++;\n");
                src.append("} catch(Exception e){" + this.destination + "(row, col, 0d);} \n");
            } else {
                src.append(this.destination).append("(row, col, UtilFunctions.stringToObject(_props.getSchema()[col], strIndexValue[1]); \n");
            }
            src.append("} \n");
            src.append("} \n");
            src.append("} \n");
            src.append("row++; \n");
        }
        return src.toString();
    }

    public String getRandomName(String base) {
        Random r = new Random();
        int low = 0;
        int high = 100000000;
        int result = r.nextInt(high - low) + low;
        return base + "_" + result;
    }

    private void getJavaCode(CodeGenTrieNode node, StringBuilder src, String currPos, boolean arrayCodeGenEnable) {
        this.getJavaCodeIndexOf(node, src, currPos, arrayCodeGenEnable);
    }

    private void getJavaCodeIndexOf(CodeGenTrieNode node, StringBuilder src, String currPos, boolean arrayCodeGenEnable) {
        CodeGenTrieNode tmpNode = null;
        if (arrayCodeGenEnable) {
            tmpNode = this.getJavaCodeRegular(node, src, currPos);
        }
        if (tmpNode == null) {
            if (node.isEndOfCondition()) {
                src.append(node.geValueCode(this.destination, currPos));
            }
            if (node.getChildren().size() > 0) {
                String currPosVariable = currPos;
                for (String key : node.getChildren().keySet()) {
                    if (key.length() > 0) {
                        currPosVariable = this.getRandomName("curPos");
                        String mKey = key.replace("\\\"", "\u00b0");
                        mKey = mKey.replace("\\", "\\\\");
                        mKey = mKey.replace("\u00b0", "\\\"");
                        if (node.getKey() == null) {
                            src.append("index = str.indexOf(\"" + mKey.replace("\\\"", "\"").replace("\"", "\\\"") + "\"); \n");
                        } else {
                            src.append("index = str.indexOf(\"" + mKey.replace("\\\"", "\"").replace("\"", "\\\"") + "\", " + currPos + "); \n");
                        }
                        src.append("if(index != -1) { \n");
                        src.append("int " + currPosVariable + " = index + " + key.length() + "; \n");
                    }
                    CodeGenTrieNode child = node.getChildren().get(key);
                    this.getJavaCodeIndexOf(child, src, currPosVariable, arrayCodeGenEnable);
                    if (key.length() <= 0) continue;
                    src.append("} \n");
                }
            }
        } else if (!tmpNode.isEndOfCondition()) {
            this.getJavaCodeIndexOf(tmpNode, src, currPos, arrayCodeGenEnable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CodeGenTrieNode getJavaCodeRegular(CodeGenTrieNode node, StringBuilder src, String currPos) {
        String conflict;
        int i;
        ArrayList<CodeGenTrieNode> nodes = new ArrayList<CodeGenTrieNode>();
        if (node.getChildren().size() != 1) return null;
        nodes.add(node);
        CodeGenTrieNode cn = node.getChildren().get(node.getChildren().keySet().iterator().next());
        while (cn.getChildren().size() <= 1) {
            nodes.add(cn);
            if (cn.getChildren().size() != 1) break;
            cn = cn.getChildren().get(cn.getChildren().keySet().iterator().next());
        }
        if (nodes.size() <= 1) return null;
        boolean isIndexSequence = true;
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> colIndexes = new ArrayList<String>();
        ArrayList<Integer> colIndexesExtra = new ArrayList<Integer>();
        int tmpIndex = 0;
        for (CodeGenTrieNode n : nodes) {
            keys.add(n.getKey());
            if (n.isEndOfCondition()) {
                colIndexes.add(n.getColIndex());
            } else {
                colIndexesExtra.add(tmpIndex);
            }
            ++tmpIndex;
        }
        if (keys.size() != colIndexes.size() && (keys.size() != colIndexes.size() + 1 || (Integer)colIndexesExtra.get(0) != 0)) {
            return null;
        }
        HashSet<String> keysSet = new HashSet<String>();
        for (i = 1; i < keys.size(); ++i) {
            keysSet.add((String)keys.get(i));
        }
        boolean isKeySingle = keysSet.size() == 1;
        for (i = 1; i < colIndexes.size() && isIndexSequence; ++i) {
            isIndexSequence = Integer.parseInt((String)colIndexes.get(i)) - Integer.parseInt((String)colIndexes.get(i - 1)) == 1;
        }
        String tmpDest = this.destination.split("\\.")[0];
        int[] cols = new int[colIndexes.size()];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            cols[i2] = Integer.parseInt((String)colIndexes.get(i2));
        }
        String string = conflict = !this.isMatrix ? this.formatIdentifyer.getConflictToken(cols) : null;
        if (colIndexes.size() == 1) {
            if (conflict != null) {
                src.append("// conflict token : " + conflict + " appended to end of value token list \n");
                this.properties.endWithValueStrings()[Integer.parseInt((String)colIndexes.get(0))].add(conflict);
                return null;
            } else {
                src.append("// conflict token for find end of array was NULL \n");
            }
            return null;
        } else {
            boolean isDelimAndSuffixesSame = false;
            if (isKeySingle && isIndexSequence) {
                String baseIndex = (String)colIndexes.get(0);
                String key = (String)keysSet.iterator().next();
                String mKey = this.refineKeyForSearch(key);
                String colIndex = this.getRandomName("colIndex");
                if (this.isMatrix) return cn;
                isDelimAndSuffixesSame = this.formatIdentifyer.isDelimAndSuffixesSame(key, cols, conflict);
                if (conflict != null) {
                    src.append("indexConflict=").append("str.indexOf(" + this.refineKeyForSearch(conflict) + "," + currPos + "); \n");
                    src.append("if (indexConflict != -1) \n");
                    src.append("parts = IOUtilFunctions.splitCSV(str.substring(" + currPos + ", indexConflict)," + mKey + "); \n");
                    src.append("else \n");
                }
                src.append("parts=IOUtilFunctions.splitCSV(str.substring(" + currPos + "), " + mKey + "); \n");
                src.append("int ").append(colIndex).append("; \n");
                src.append("for (int i=0; i< Math.min(parts.length, " + colIndexes.size() + "); i++) {\n");
                src.append(colIndex).append(" = i+").append(baseIndex).append("; \n");
                if (isDelimAndSuffixesSame) {
                    if (!this.isMatrix) {
                        src.append(this.destination).append("(row," + colIndex + ",UtilFunctions.stringToObject(" + tmpDest + ".getSchema()[" + colIndex + "], parts[i])); \n");
                    } else {
                        src.append(this.destination).append("(row," + colIndex + ",UtilFunctions.parseToDouble(parts[i], null)); \n");
                    }
                } else {
                    src.append("endPos=TemplateUtil.getEndPos(parts[i], parts[i].length(),0,endWithValueString[" + colIndex + "]); \n");
                    if (!this.isMatrix) {
                        src.append(this.destination).append("(row," + colIndex + ",UtilFunctions.stringToObject(" + tmpDest + ".getSchema()[" + colIndex + "], parts[i].substring(0,endPos))); \n");
                    } else {
                        src.append(this.destination).append("(row," + colIndex + ",UtilFunctions.parseToDouble(parts[i].substring(0,endPos), null)); \n");
                    }
                }
                src.append("} \n");
                if (conflict == null) return cn;
                src.append("if (indexConflict !=-1) \n");
                src.append("index = indexConflict; \n");
                return cn;
            }
            if (!isKeySingle || isIndexSequence) return null;
            StringBuilder srcColIndexes = new StringBuilder("new int[]{");
            for (String c : colIndexes) {
                srcColIndexes.append(c).append(",");
            }
            srcColIndexes.deleteCharAt(srcColIndexes.length() - 1);
            srcColIndexes.append("}");
            String colIndexName = this.getRandomName("targetColIndex");
            src.append("int[] ").append(colIndexName).append("=").append((CharSequence)srcColIndexes).append("; \n");
            String key = (String)keysSet.iterator().next();
            String mKey = this.refineKeyForSearch(key);
            if (!this.isMatrix) {
                isDelimAndSuffixesSame = this.formatIdentifyer.isDelimAndSuffixesSame(key, cols, conflict);
                if (conflict != null) {
                    src.append("indexConflict = ").append("str.indexOf(" + this.refineKeyForSearch(conflict) + "," + currPos + "); \n");
                    src.append("if (indexConflict != -1) \n");
                    src.append("parts = IOUtilFunctions.splitCSV(str.substring(" + currPos + ", indexConflict), " + mKey + "); \n");
                    src.append("else \n");
                }
            }
            src.append("parts = IOUtilFunctions.splitCSV(str.substring(" + currPos + "), " + mKey + "); \n");
            src.append("for (int i=0; i< Math.min(parts.length, " + colIndexes.size() + "); i++) {\n");
            if (isDelimAndSuffixesSame) {
                if (!this.isMatrix) {
                    src.append(this.destination).append("(row," + colIndexName + "[i],UtilFunctions.stringToObject(" + tmpDest + ".getSchema()[" + colIndexName + "[i]], parts[i])); \n");
                } else {
                    src.append(this.destination).append("(row," + colIndexName + "[i],UtilFunctions.parseToDouble(parts[i], null)); \n");
                }
            } else if (!this.isMatrix) {
                src.append("endPos = TemplateUtil.getEndPos(parts[i], parts[i].length(), 0, endWithValueString[" + colIndexName + "[i]]); \n");
                src.append(this.destination).append("(row," + colIndexName + "[i],UtilFunctions.stringToObject(" + tmpDest + ".getSchema()[" + colIndexName + "[i]], parts[i].substring(0, endPos))); \n");
            } else {
                src.append(this.destination).append("(row," + colIndexName + "[i],UtilFunctions.parseToDouble(parts[i].substring(0, endPos), null)); \n");
            }
            src.append("} \n");
            if (conflict == null) return cn;
            src.append("if (indexConflict !=-1) \n");
            src.append("index = indexConflict; \n");
            return cn;
        }
    }

    private String refineKeyForSearch(String k) {
        Object mKey = k.replace("\\\"", "\u00b0");
        mKey = ((String)mKey).replace("\\", "\\\\");
        mKey = ((String)mKey).replace("\u00b0", "\\\"");
        mKey = "\"" + ((String)mKey).replace("\\\"", "\"").replace("\"", "\\\"") + "\"";
        return mKey;
    }

    public void setMatrix(boolean matrix) {
        this.isMatrix = matrix;
    }
}

