/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;

public class DMVUtils {
    public static final char DIGIT = 'd';
    public static final char LOWER = 'l';
    public static final char UPPER = 'u';
    public static final char ALPHA = 'a';
    public static final char SPACE = 's';
    public static final char DOT = 't';
    public static final char OTHER = 'y';
    public static final char ARBITRARY_LEN = '+';
    public static final char MINUS = '-';

    public static FrameBlock syntacticalPatternDiscovery(FrameBlock frame, double threshold, String disguised_value) {
        int idx;
        String disguisedVal = disguised_value;
        int numCols = frame.getNumColumns();
        int numRows = frame.getNumRows();
        ArrayList<Map<String, Integer>> table_Hist = new ArrayList<Map<String, Integer>>(numCols);
        for (idx = 0; idx < numCols; ++idx) {
            Object c = frame.getColumnData(idx);
            String[] attr = (String[])c;
            String key = "";
            for (int i = 0; i < numRows; ++i) {
                key = attr[i] == null ? "NULL" : attr[i];
                DMVUtils.addDistinctValueOrIncrementCounter(table_Hist, key, (Integer)idx);
            }
        }
        idx = -1;
        block2: for (Map<String, Integer> col_Hist : table_Hist) {
            ++idx;
            HashMap<String, Double> dominant_patterns_ratio = new HashMap();
            Map<String, Integer> prev_pattern_hist = col_Hist;
            for (LEVEL_ENUM level : LEVEL_ENUM.values()) {
                dominant_patterns_ratio.clear();
                Map<String, Integer> current_pattern_hist = DMVUtils.LevelsExecutor(prev_pattern_hist, level);
                dominant_patterns_ratio = DMVUtils.calculatePatternsRatio(current_pattern_hist, numRows);
                String dominant_pattern = DMVUtils.findDominantPattern(dominant_patterns_ratio, threshold);
                if (dominant_pattern != null) {
                    DMVUtils.detectDisguisedValues(dominant_pattern, frame.getColumnData(idx), idx, frame, level, disguisedVal);
                    continue block2;
                }
                prev_pattern_hist = current_pattern_hist;
            }
        }
        return frame;
    }

    public static Map<String, Double> calculatePatternsRatio(Map<String, Integer> patterns_hist, int nr_entries) {
        HashMap<String, Double> patterns_ratio_map = new HashMap<String, Double>();
        for (Map.Entry<String, Integer> e : patterns_hist.entrySet()) {
            String pattern = e.getKey();
            double nr_occurences = e.getValue().intValue();
            double current_ratio = nr_occurences / (double)nr_entries;
            patterns_ratio_map.put(pattern, current_ratio);
        }
        return patterns_ratio_map;
    }

    public static String findDominantPattern(Map<String, Double> dominant_patterns, double threshold) {
        for (Map.Entry<String, Double> e : dominant_patterns.entrySet()) {
            String pattern = e.getKey();
            Double pattern_ratio = e.getValue();
            if (!(pattern_ratio > threshold)) continue;
            return pattern;
        }
        return null;
    }

    private static void addDistinctValueOrIncrementCounter(ArrayList<Map<String, Integer>> maps, String key, Integer idx) {
        if (maps.size() == idx.intValue()) {
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            m.put(key, 1);
            maps.add(m);
            return;
        }
        if (!maps.get(idx).containsKey(key)) {
            maps.get(idx).put(key, 1);
        } else {
            maps.get(idx).compute(key, (k, v) -> v + 1);
        }
    }

    private static void addDistinctValueOrIncrementCounter(Map<String, Integer> map, String encoded_value, Integer nr_occurrences) {
        if (!map.containsKey(encoded_value)) {
            map.put(encoded_value, nr_occurrences);
        } else {
            map.compute(encoded_value, (k, v) -> v + nr_occurrences);
        }
    }

    public static Map<String, Integer> LevelsExecutor(Map<String, Integer> old_pattern_hist, LEVEL_ENUM level) {
        HashMap<String, Integer> new_pattern_hist = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> e : old_pattern_hist.entrySet()) {
            String new_pattern;
            String pattern = e.getKey();
            Integer nr_of_occurrences = e.getValue();
            switch (level) {
                case LEVEL1: {
                    new_pattern = DMVUtils.encodeRawString(pattern);
                    break;
                }
                case LEVEL2: {
                    new_pattern = DMVUtils.removeNumbers(pattern);
                    break;
                }
                case LEVEL3: {
                    new_pattern = DMVUtils.removeUpperLowerCase(pattern);
                    break;
                }
                case LEVEL4: {
                    new_pattern = DMVUtils.removeInnerCharacterInPattern(pattern, 'd', 't');
                    break;
                }
                case LEVEL5: {
                    new_pattern = DMVUtils.removeInnerCharacterInPattern(pattern, 'a', 's');
                    break;
                }
                case LEVEL6: {
                    new_pattern = DMVUtils.acceptNegativeNumbersAsDigits(pattern);
                    break;
                }
                default: {
                    new_pattern = "";
                }
            }
            DMVUtils.addDistinctValueOrIncrementCounter(new_pattern_hist, new_pattern, nr_of_occurrences);
        }
        return new_pattern_hist;
    }

    public static String acceptNegativeNumbersAsDigits(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder tmp = new StringBuilder();
        boolean currently_minus_digit = false;
        for (char ch : chars) {
            if (ch == '-' && !currently_minus_digit) {
                currently_minus_digit = true;
                continue;
            }
            if (ch == 'd' && currently_minus_digit) {
                tmp.append(ch);
                currently_minus_digit = false;
                continue;
            }
            if (currently_minus_digit) {
                tmp.append('-');
                tmp.append(ch);
                currently_minus_digit = false;
                continue;
            }
            tmp.append(ch);
        }
        return tmp.toString();
    }

    public static String removeInnerCharacterInPattern(String pattern, char outter_char, char inner_char) {
        char[] chars = pattern.toCharArray();
        StringBuilder tmp = new StringBuilder();
        boolean currently_digit = false;
        for (char ch : chars) {
            if (ch == outter_char && !currently_digit) {
                currently_digit = true;
                tmp.append(ch);
                continue;
            }
            if (currently_digit && (ch == outter_char || ch == inner_char)) continue;
            if (ch != inner_char && ch != '+') {
                currently_digit = false;
                tmp.append(ch);
                continue;
            }
            if (tmp.length() <= 0 || tmp.charAt(tmp.length() - 1) == '+') continue;
            tmp.append(ch);
        }
        return tmp.toString();
    }

    public static String removeUpperLowerCase(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder tmp = new StringBuilder();
        boolean currently_alphabetic = false;
        for (char ch : chars) {
            if (ch == 'u' || ch == 'l') {
                if (currently_alphabetic) continue;
                currently_alphabetic = true;
                tmp.append('a');
                continue;
            }
            if (ch == '+') {
                if (tmp.charAt(tmp.length() - 1) == '+') continue;
                tmp.append(ch);
                continue;
            }
            tmp.append(ch);
            currently_alphabetic = false;
        }
        return tmp.toString();
    }

    private static String removeNumbers(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder tmp = new StringBuilder();
        for (char ch : chars) {
            if (Character.isDigit(ch)) {
                tmp.append('+');
                continue;
            }
            tmp.append(ch);
        }
        return tmp.toString();
    }

    public static String encodeRawString(String input) {
        char[] chars = input.toCharArray();
        StringBuilder tmp = new StringBuilder();
        for (char ch : chars) {
            tmp.append(DMVUtils.getCharClass(ch));
        }
        return DMVUtils.getFrequencyOfEachConsecutiveChar(tmp.toString());
    }

    private static char getCharClass(char c) {
        if (Character.isDigit(c)) {
            return 'd';
        }
        if (Character.isLowerCase(c)) {
            return 'l';
        }
        if (Character.isUpperCase(c)) {
            return 'u';
        }
        if (Character.isSpaceChar(c)) {
            return 's';
        }
        if (c == '.') {
            return 't';
        }
        if (c == '-') {
            return '-';
        }
        return 'y';
    }

    public static String getFrequencyOfEachConsecutiveChar(String s) {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            int count = 1;
            while (i + 1 < s.length() && s.charAt(i) == s.charAt(i + 1)) {
                ++i;
                ++count;
            }
            retval.append(s.charAt(i));
            retval.append(count);
        }
        return retval.toString();
    }

    private static void detectDisguisedValues(String dom_pattern, Object col, int col_idx, FrameBlock frameBlock, LEVEL_ENUM level, String disguisedVal) {
        int row_idx = -1;
        String pattern = "";
        String[] attr = (String[])col;
        int numRows = frameBlock.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            String value = attr[i] == null ? "NULL" : attr[i];
            switch (level) {
                case LEVEL1: {
                    pattern = DMVUtils.encodeRawString(value);
                    break;
                }
                case LEVEL2: {
                    pattern = DMVUtils.encodeRawString(value);
                    pattern = DMVUtils.removeNumbers(pattern);
                    break;
                }
                case LEVEL3: {
                    pattern = DMVUtils.encodeRawString(value);
                    pattern = DMVUtils.removeNumbers(pattern);
                    pattern = DMVUtils.removeUpperLowerCase(pattern);
                    break;
                }
                case LEVEL4: {
                    pattern = DMVUtils.encodeRawString(value);
                    pattern = DMVUtils.removeNumbers(pattern);
                    pattern = DMVUtils.removeUpperLowerCase(pattern);
                    pattern = DMVUtils.removeInnerCharacterInPattern(pattern, 'd', 't');
                    break;
                }
                case LEVEL5: {
                    pattern = DMVUtils.encodeRawString(value);
                    pattern = DMVUtils.removeNumbers(pattern);
                    pattern = DMVUtils.removeUpperLowerCase(pattern);
                    pattern = DMVUtils.removeInnerCharacterInPattern(pattern, 'd', 't');
                    pattern = DMVUtils.removeInnerCharacterInPattern(pattern, 'a', 's');
                    break;
                }
                case LEVEL6: {
                    pattern = DMVUtils.encodeRawString(value);
                    pattern = DMVUtils.removeNumbers(pattern);
                    pattern = DMVUtils.removeUpperLowerCase(pattern);
                    pattern = DMVUtils.removeInnerCharacterInPattern(pattern, 'd', 't');
                    pattern = DMVUtils.removeInnerCharacterInPattern(pattern, 'a', 's');
                    pattern = DMVUtils.acceptNegativeNumbersAsDigits(pattern);
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Could not find suitable level");
                }
            }
            ++row_idx;
            if (pattern.equals(dom_pattern)) continue;
            frameBlock.set(row_idx, col_idx, disguisedVal);
        }
    }

    public static enum LEVEL_ENUM {
        LEVEL1,
        LEVEL2,
        LEVEL3,
        LEVEL4,
        LEVEL5,
        LEVEL6;

    }
}

