/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.mongodb.MongoDBSource;
import org.slf4j.Logger;

public class MongoDBSourceImpl
implements MongoDBSource {
    private final Logger logger;
    private final MongoClient mongoClient;

    public MongoDBSourceImpl(Logger logger, @Symbol(value="tapestry.mongodb.conns-per-host") int connectionPerHost, @Symbol(value="tapestry.mongodb.read_preference") ReadPreference readPreference, @Symbol(value="tapestry.mongodb.write_concern") WriteConcern writeConcern, List<ServerAddress> serverAddresses) {
        this.logger = logger;
        MongoClientOptions options = new MongoClientOptions.Builder().connectionsPerHost(connectionPerHost).writeConcern(writeConcern).readPreference(readPreference).build();
        if (serverAddresses.isEmpty()) {
            try {
                this.mongoClient = new MongoClient(new ServerAddress(), options);
            }
            catch (UnknownHostException uhe) {
                throw new RuntimeException(uhe);
            }
        } else {
            this.mongoClient = new MongoClient(serverAddresses, options);
        }
    }

    @Override
    public MongoClient getMongo() {
        return this.mongoClient;
    }
}

