/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.ref.WeakReference;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.ServiceProxyProvider;
import org.apache.tapestry5.ioc.internal.ServiceProxyToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SerializationSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationSupport.class);
    private static WeakReference<ServiceProxyProvider> providerRef;

    SerializationSupport() {
    }

    static synchronized void setProvider(ServiceProxyProvider proxyProvider) {
        ServiceProxyProvider existing = SerializationSupport.currentProvider();
        if (existing != null) {
            LOGGER.error(IOCMessages.overlappingServiceProxyProviders());
        }
        providerRef = new WeakReference<ServiceProxyProvider>(proxyProvider);
    }

    private static ServiceProxyProvider currentProvider() {
        return providerRef == null ? null : (ServiceProxyProvider)providerRef.get();
    }

    static synchronized void clearProvider(ServiceProxyProvider proxyProvider) {
        ServiceProxyProvider existing = SerializationSupport.currentProvider();
        if (existing != proxyProvider) {
            LOGGER.error(IOCMessages.unexpectedServiceProxyProvider());
            return;
        }
        providerRef = null;
    }

    static synchronized Object readResolve(String serviceId) {
        ServiceProxyProvider provider = SerializationSupport.currentProvider();
        if (provider == null) {
            throw new RuntimeException(IOCMessages.noProxyProvider(serviceId));
        }
        return provider.provideServiceProxy(serviceId);
    }

    static ServiceProxyToken createToken(String serviceId) {
        return new ServiceProxyToken(serviceId);
    }
}

