/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthCheckCondition;
import com.atlassian.util.concurrent.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportHealthCheckModuleDescriptor
extends AbstractModuleDescriptor<SupportHealthCheck> {
    private static final Logger log = LoggerFactory.getLogger(SupportHealthCheckModuleDescriptor.class);
    public static final int DEFAULT_TIMEOUT_MILLIS = Integer.getInteger("atlassian.healthcheck.timeout-ms", (int)TimeUnit.SECONDS.toMillis(5L));
    public static final int MAX_TIMEOUT_MILLIS = Integer.getInteger("atlassian.healthcheck.max-timeout-ms", (int)TimeUnit.SECONDS.toMillis(20L));
    private int timeOut;
    private String tag;
    private List<SupportHealthCheckCondition> conditions = new ArrayList<SupportHealthCheckCondition>();
    private HostContainer hostContainer;

    public SupportHealthCheckModuleDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer) {
        super(moduleFactory);
        this.hostContainer = hostContainer;
    }

    public SupportHealthCheck getModule() {
        return (SupportHealthCheck)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.initializeTimeout(element);
        this.tag = element.attributeValue("tag");
        List conditionElements = element.elements("condition");
        for (Element condition : conditionElements) {
            try {
                this.conditions.add(this.parseCondition(condition));
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Could not parse health check condition.", (Throwable)e);
            }
        }
    }

    private SupportHealthCheckCondition parseCondition(Element condition) throws ClassNotFoundException {
        String className = condition.attribute("class").getValue();
        Class clazz = this.plugin.loadClass(className, this.plugin.getClass());
        return (SupportHealthCheckCondition)this.hostContainer.create(clazz);
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    private void initializeTimeout(Element element) {
        String timeoutString = element.attributeValue("time-out");
        if (timeoutString == null) {
            this.timeOut = DEFAULT_TIMEOUT_MILLIS;
        } else {
            try {
                int customTimeOut = Integer.parseInt(timeoutString);
                if (customTimeOut > MAX_TIMEOUT_MILLIS) {
                    this.timeOut = MAX_TIMEOUT_MILLIS;
                    log.warn("Custom timeout of {} ms exceeds maximum timeout of {} ms, timeout is now set to max timeout", (Object)customTimeOut, (Object)MAX_TIMEOUT_MILLIS);
                } else {
                    this.timeOut = customTimeOut;
                }
            }
            catch (NumberFormatException exception) {
                this.timeOut = DEFAULT_TIMEOUT_MILLIS;
                log.warn("Error parsing custom timeout, timeout is now set to a default of {} ms", (Object)DEFAULT_TIMEOUT_MILLIS);
            }
        }
    }

    public String getTag() {
        return this.tag;
    }

    public List<SupportHealthCheckCondition> getConditions() {
        return this.conditions;
    }
}

