/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.PropertyView;
import org.opengis.util.GenericName;

class AttributeView<V>
extends AbstractAttribute<V> {
    private static final long serialVersionUID = 3617999929561826634L;
    final AbstractFeature feature;
    final String name;

    private AttributeView(AbstractFeature feature, DefaultAttributeType<V> type) {
        super(type);
        this.feature = feature;
        this.name = type.getName().toString();
    }

    static <V> AbstractAttribute<V> create(AbstractFeature feature, DefaultAttributeType<V> type) {
        if (AttributeView.isSingleton(type.getMaximumOccurs())) {
            return new Singleton<V>(feature, type);
        }
        return new AttributeView<V>(feature, type);
    }

    @Override
    public final GenericName getName() {
        return this.type.getName();
    }

    @Override
    public V getValue() {
        return this.type.getValueClass().cast(PropertyView.getValue(this.feature, this.name));
    }

    @Override
    public void setValue(V value) {
        PropertyView.setValue(this.feature, this.name, value);
    }

    @Override
    public Collection<V> getValues() {
        return PropertyView.getValues(this.feature, this.name, this.type.getValueClass());
    }

    @Override
    public final void setValues(Collection<? extends V> values) {
        PropertyView.setValues(this.feature, this.name, values);
    }

    @Override
    public final Map<String, AbstractAttribute<?>> characteristics() {
        return Collections.emptyMap();
    }

    public final int hashCode() {
        return PropertyView.hashCode(this.feature, this.name);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            AttributeView that = (AttributeView)obj;
            return this.feature == that.feature && Objects.equals(this.name, that.name);
        }
        return false;
    }

    @Override
    public final String toString() {
        return PropertyView.toString(this.getClass(), this.type.getValueClass(), this.getName(), this.getValues());
    }

    private static final class Singleton<V>
    extends AttributeView<V> {
        private static final long serialVersionUID = -808239726590009163L;

        Singleton(AbstractFeature feature, DefaultAttributeType<V> type) {
            super(feature, type);
        }

        @Override
        public V getValue() {
            return this.type.getValueClass().cast(this.feature.getPropertyValue(this.name));
        }

        @Override
        public void setValue(V value) {
            this.feature.setPropertyValue(this.name, value);
        }

        @Override
        public Collection<V> getValues() {
            return PropertyView.singletonOrEmpty(this.getValue());
        }
    }
}

