/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs.johnzon;

import jakarta.activation.DataSource;
import jakarta.annotation.Priority;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.io.File;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import org.apache.johnzon.jaxrs.jsonb.jaxrs.JsonbJaxrsProvider;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.openejb.server.cxf.rs.johnzon.TomEEJsonbPropertyVisibilityStrategy;

@Provider
@Produces(value={"application/json", "application/*+json"})
@Consumes(value={"application/json", "application/*+json"})
@Priority(value=5000)
public class TomEEJsonbProvider<T>
extends JsonbJaxrsProvider<T> {
    public TomEEJsonbProvider() {
        this.config.withPropertyVisibilityStrategy((PropertyVisibilityStrategy)new TomEEJsonbPropertyVisibilityStrategy());
        this.setThrowNoContentExceptionOnEmptyStreams(true);
        this.config.setProperty("johnzon.use-big-decimal-for-object", (Object)true);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!TomEEJsonbProvider.isJson(mediaType)) {
            return false;
        }
        if (DataSource.class.isAssignableFrom(type)) {
            return false;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return false;
        }
        if (File.class.isAssignableFrom(type)) {
            return false;
        }
        if (Reader.class.isAssignableFrom(type)) {
            return false;
        }
        return super.isWriteable(type, genericType, annotations, mediaType);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!TomEEJsonbProvider.isJson(mediaType)) {
            return false;
        }
        if (DataSource.class.isAssignableFrom(type)) {
            return false;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return false;
        }
        if (File.class.isAssignableFrom(type)) {
            return false;
        }
        if (Reader.class.isAssignableFrom(type)) {
            return false;
        }
        return super.isReadable(type, genericType, annotations, mediaType);
    }

    public static boolean isJson(MediaType mediaType) {
        if (!mediaType.getType().equals("application")) {
            return false;
        }
        if (mediaType.getSubtype().equals("json")) {
            return true;
        }
        return mediaType.getSubtype().endsWith("+json");
    }

    public void setDateFormat(String dateFormat) {
        this.config.setProperty("jsonb.date-format", (Object)dateFormat);
    }

    public void setLocale(Locale locale) {
        this.config.setProperty("jsonb.locale", (Object)locale);
    }

    public void setAccessMode(AccessMode accessMode) {
        this.config.setProperty("johnzon.accessMode", (Object)accessMode);
    }
}

