/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.Namespace;
import org.opensaml.saml.common.SAMLObjectContentReference;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.ContentReference;
import org.slf4j.Logger;

public final class SAMLObjectSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(SAMLObjectSupport.class);

    private SAMLObjectSupport() {
    }

    public static void declareNonVisibleNamespaces(@Nonnull SignableSAMLObject signableObject) {
        Signature sig;
        if (signableObject.getDOM() == null && (sig = signableObject.getSignature()) != null) {
            LOG.debug("Examining signed object for content references with exclusive canonicalization transform");
            boolean sawExclusive = false;
            for (ContentReference cr : sig.getContentReferences()) {
                List<String> transforms;
                if (!(cr instanceof SAMLObjectContentReference) || !(transforms = ((SAMLObjectContentReference)cr).getTransforms()).contains("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") && !transforms.contains("http://www.w3.org/2001/10/xml-exc-c14n#")) continue;
                sawExclusive = true;
                break;
            }
            if (sawExclusive) {
                LOG.debug("Saw exclusive transform, declaring non-visible namespaces on signed object");
                for (Namespace ns : signableObject.getNamespaceManager().getNonVisibleNamespaces()) {
                    assert (ns != null);
                    signableObject.getNamespaceManager().registerNamespaceDeclaration(ns);
                }
            }
        }
    }
}

