/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.messaging.context;

import java.time.Instant;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.RequestAbstractType;
import org.opensaml.saml.saml1.core.ResponseAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;

public final class SAMLMessageInfoContext
extends BaseContext {
    @Nullable
    @NotEmpty
    private String messageId;
    @Nullable
    private Instant issueInstant;

    @Nullable
    @NotEmpty
    public String getMessageId() {
        if (this.messageId == null) {
            this.messageId = this.resolveMessageId();
        }
        return this.messageId;
    }

    public void setMessageId(@Nullable String newMessageId) {
        this.messageId = StringSupport.trimOrNull((String)newMessageId);
    }

    @Nullable
    public Instant getMessageIssueInstant() {
        if (this.issueInstant == null) {
            this.issueInstant = this.resolveIssueInstant();
        }
        return this.issueInstant;
    }

    public void setMessageIssueInstant(@Nullable Instant messageIssueInstant) {
        this.issueInstant = messageIssueInstant;
    }

    @Nullable
    protected String resolveMessageId() {
        SAMLObject samlMessage = this.resolveSAMLMessage();
        if (samlMessage instanceof org.opensaml.saml.saml2.core.RequestAbstractType) {
            org.opensaml.saml.saml2.core.RequestAbstractType msg = (org.opensaml.saml.saml2.core.RequestAbstractType)samlMessage;
            return msg.getID();
        }
        if (samlMessage instanceof StatusResponseType) {
            StatusResponseType msg = (StatusResponseType)samlMessage;
            return msg.getID();
        }
        if (samlMessage instanceof ResponseAbstractType) {
            ResponseAbstractType msg = (ResponseAbstractType)samlMessage;
            return msg.getID();
        }
        if (samlMessage instanceof RequestAbstractType) {
            RequestAbstractType msg = (RequestAbstractType)samlMessage;
            return msg.getID();
        }
        return null;
    }

    @Nullable
    protected Instant resolveIssueInstant() {
        SAMLObject samlMessage = this.resolveSAMLMessage();
        if (samlMessage instanceof org.opensaml.saml.saml2.core.RequestAbstractType) {
            org.opensaml.saml.saml2.core.RequestAbstractType msg = (org.opensaml.saml.saml2.core.RequestAbstractType)samlMessage;
            return msg.getIssueInstant();
        }
        if (samlMessage instanceof StatusResponseType) {
            StatusResponseType msg = (StatusResponseType)samlMessage;
            return msg.getIssueInstant();
        }
        if (samlMessage instanceof ResponseAbstractType) {
            ResponseAbstractType msg = (ResponseAbstractType)samlMessage;
            return msg.getIssueInstant();
        }
        if (samlMessage instanceof RequestAbstractType) {
            RequestAbstractType msg = (RequestAbstractType)samlMessage;
            return msg.getIssueInstant();
        }
        return null;
    }

    @Nullable
    protected SAMLObject resolveSAMLMessage() {
        MessageContext p;
        Object object;
        BaseContext baseContext = this.getParent();
        if (baseContext instanceof MessageContext && (object = (p = (MessageContext)baseContext).getMessage()) instanceof SAMLObject) {
            SAMLObject msg = (SAMLObject)object;
            return msg;
        }
        return null;
    }
}

