/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.ResponseAbstractType;
import org.opensaml.xmlsec.signature.Signature;

public abstract class ResponseAbstractTypeImpl
extends AbstractSignableSAMLObject
implements ResponseAbstractType {
    @Nullable
    private String id;
    @Nullable
    private SAMLVersion version = SAMLVersion.VERSION_11;
    @Nullable
    private String inResponseTo;
    @Nullable
    private Instant issueInstant;
    @Nullable
    private String recipient;

    protected ResponseAbstractTypeImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public String getID() {
        return this.id;
    }

    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Nullable
    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public void setInResponseTo(@Nullable String to) {
        this.inResponseTo = this.prepareForAssignment(this.inResponseTo, to);
    }

    @Nullable
    public SAMLVersion getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable SAMLVersion newVersion) {
        this.version = (SAMLVersion)this.prepareForAssignment(this.version, newVersion);
    }

    @Nullable
    public Instant getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(@Nullable Instant date) {
        this.issueInstant = (Instant)this.prepareForAssignment(this.issueInstant, date);
    }

    @Nullable
    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(@Nullable String recip) {
        this.recipient = this.prepareForAssignment(this.recipient, recip);
    }

    @Nullable
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        Signature sig = this.getSignature();
        if (sig != null) {
            return CollectionSupport.singletonList((Object)sig);
        }
        return null;
    }
}

