/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.rest;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.NameBinding;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.Injection;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.IdPropertiesInfo;
import org.apache.openejb.assembler.classic.ParamValueInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.assembler.classic.util.PojoUtil;
import org.apache.openejb.assembler.classic.util.ServiceConfiguration;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceManager;
import org.apache.openejb.server.httpd.BasicAuthHttpListenerWrapper;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.rest.EJBRestServiceInfo;
import org.apache.openejb.server.rest.InternalApplication;
import org.apache.openejb.server.rest.OpenEJBRestRuntimeException;
import org.apache.openejb.server.rest.RsHttpListener;
import org.apache.openejb.server.rest.RsRegistry;
import org.apache.openejb.server.rest.RsRegistryImpl;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.xbean.finder.MetaAnnotatedClass;

public abstract class RESTService
implements ServerService,
SelfManaging {
    public static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_RS, RESTService.class);
    private static final boolean OLD_WEBSERVICE_DEPLOYMENT = SystemInstance.get().getOptions().get("openejb.webservice.old-deployment", false);
    public static final String OPENEJB_USE_APPLICATION_PROPERTY = "openejb.jaxrs.application";
    private static final String APPLICATION_DEPLOYMENT = SystemInstance.get().getOptions().get("openejb.jaxrs.application", "true");
    public static final String OPENEJB_JAXRS_PROVIDERS_AUTO_PROP = "openejb.jaxrs.providers.auto";
    private static final String IP = "n/a";
    private static final int PORT = -1;
    public static final String NOPATH_PREFIX = "http://nopath/";
    private final Set<AppInfo> deployedApplications = new HashSet<AppInfo>();
    private final Set<WebAppInfo> deployedWebApps = new HashSet<WebAppInfo>();
    private Assembler assembler;
    private CoreContainerSystem containerSystem;
    private RsRegistry rsRegistry;
    private final List<DeployedService> services = new ArrayList<DeployedService>();
    private String virtualHost = "localhost";
    private String auth = "NONE";
    private String realm = "PropertiesLogin";
    protected boolean enabled = true;
    private final String wildcard = SystemInstance.get().getProperty("openejb.rest.wildcard", ".*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterApplicationCreated(AppInfo appInfo, WebAppInfo webApp) {
        block41: {
            if ("false".equalsIgnoreCase(appInfo.properties.getProperty("openejb.jaxrs.on", "true"))) {
                return;
            }
            WebContext webContext = this.containerSystem.getWebContextByHost(webApp.moduleId, webApp.host != null ? webApp.host : this.virtualHost);
            if (webContext == null) {
                return;
            }
            if (!this.deployedWebApps.add(webApp)) {
                return;
            }
            Map<String, EJBRestServiceInfo> restEjbs = this.getRestEjbs(appInfo, webApp.moduleId);
            ClassLoader classLoader = RESTService.getClassLoader(webContext.getClassLoader());
            Collection injections = webContext.getInjections();
            WebBeansContext owbCtx = webContext.getWebbeansContext() != null ? webContext.getWebbeansContext() : webContext.getAppContext().getWebBeansContext();
            Context context = webContext.getJndiEnc();
            if (context == null) {
                context = webContext.getAppContext().getAppJndiContext();
            }
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            HashSet<Object> additionalProviders = new HashSet<Object>();
            this.addAppProvidersIfNeeded(appInfo, webApp, classLoader, additionalProviders);
            Collection pojoConfigurations = null;
            try {
                boolean deploymentWithApplication = "true".equalsIgnoreCase(appInfo.properties.getProperty(OPENEJB_USE_APPLICATION_PROPERTY, APPLICATION_DEPLOYMENT));
                if (deploymentWithApplication) {
                    for (Object app : webApp.restApplications) {
                        Application application;
                        Class<?> appClazz;
                        boolean appSkipped = false;
                        Object prefix = "/";
                        try {
                            appClazz = classLoader.loadClass((String)app);
                            application = (Application)Application.class.cast(appClazz.newInstance());
                            if (owbCtx != null && owbCtx.getBeanManagerImpl().isInUse()) {
                                try {
                                    webContext.inject((Object)application);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (Exception e) {
                            throw new OpenEJBRestRuntimeException("can't create class " + (String)app, e);
                        }
                        application = this.wrapApplication(appInfo, application);
                        HashSet classes = new HashSet(application.getClasses());
                        Set singletons = application.getSingletons();
                        if (classes.size() + singletons.size() == 0) {
                            appSkipped = true;
                        } else {
                            for (Object clazz : classes) {
                                if (RESTService.isProvider(clazz)) {
                                    additionalProviders.add(clazz);
                                    continue;
                                }
                                if (this.hasEjbAndIsNotAManagedBean(restEjbs, ((Class)clazz).getName()) || PojoUtil.findConfiguration((Collection)(pojoConfigurations = PojoUtil.findPojoConfig((Collection)pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp)), (String)((Class)clazz).getName()) == null) continue;
                                deploymentWithApplication = false;
                                RESTService.logOldDeploymentUsage(((Class)clazz).getName());
                            }
                            if (deploymentWithApplication) {
                                for (Object o : singletons) {
                                    Class<?> clazz = o.getClass();
                                    if (RESTService.isProvider(clazz)) {
                                        additionalProviders.add(o);
                                        continue;
                                    }
                                    if (this.hasEjbAndIsNotAManagedBean(restEjbs, clazz.getName()) || PojoUtil.findConfiguration((Collection)(pojoConfigurations = PojoUtil.findPojoConfig((Collection)pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp)), (String)clazz.getName()) == null) continue;
                                    deploymentWithApplication = false;
                                    RESTService.logOldDeploymentUsage(clazz.getName());
                                }
                            }
                        }
                        if (deploymentWithApplication) {
                            String path = RESTService.appPrefix(webApp, appClazz);
                            prefix = path != null ? (String)prefix + path + this.wildcard : (String)prefix + this.wildcard;
                        }
                        if (deploymentWithApplication) {
                            if (appSkipped || application == null) {
                                application = !InternalApplication.class.isInstance(application) ? new InternalApplication(application) : application;
                                for (Object clazz : webApp.restClass) {
                                    try {
                                        Class<?> loaded = classLoader.loadClass((String)clazz);
                                        if (!RESTService.isProvider(loaded)) {
                                            if (PojoUtil.findConfiguration((Collection)(pojoConfigurations = PojoUtil.findPojoConfig((Collection)pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp)), (String)loaded.getName()) != null) {
                                                deploymentWithApplication = false;
                                                RESTService.logOldDeploymentUsage(loaded.getName());
                                                break;
                                            }
                                            application.getClasses().add(loaded);
                                            continue;
                                        }
                                        additionalProviders.add(loaded);
                                    }
                                    catch (Exception e) {
                                        throw new OpenEJBRestRuntimeException("can't load class " + (String)clazz, e);
                                    }
                                }
                                if (deploymentWithApplication) {
                                    this.addEjbToApplication(application, restEjbs);
                                    if (!((String)prefix).endsWith(this.wildcard)) {
                                        prefix = (String)prefix + this.wildcard;
                                    }
                                }
                            }
                            if (!application.getClasses().isEmpty() || !application.getSingletons().isEmpty()) {
                                pojoConfigurations = PojoUtil.findPojoConfig((Collection)pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp);
                                this.deployApplication(appInfo, webApp.contextRoot, restEjbs, classLoader, injections, owbCtx, context, additionalProviders, pojoConfigurations, application, (String)prefix);
                            }
                        }
                        if (deploymentWithApplication) continue;
                        this.fullServletDeployment(appInfo, webApp, webContext, restEjbs, classLoader, injections, owbCtx, context, additionalProviders, pojoConfigurations);
                    }
                    if (webApp.restApplications.isEmpty()) {
                        InternalApplication application = new InternalApplication(null);
                        for (String clazz : webApp.restClass) {
                            try {
                                Class<?> loaded = classLoader.loadClass(clazz);
                                if (!RESTService.isProvider(loaded)) {
                                    if (PojoUtil.findConfiguration((Collection)(pojoConfigurations = PojoUtil.findPojoConfig(pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp)), (String)loaded.getName()) != null) {
                                        deploymentWithApplication = false;
                                        RESTService.logOldDeploymentUsage(loaded.getName());
                                        break;
                                    }
                                    application.getClasses().add(loaded);
                                    continue;
                                }
                                additionalProviders.add(loaded);
                            }
                            catch (Exception e) {
                                throw new OpenEJBRestRuntimeException("can't load class " + clazz, e);
                            }
                        }
                        this.addEjbToApplication(application, restEjbs);
                        if (deploymentWithApplication) {
                            if (!application.getClasses().isEmpty() || !application.getSingletons().isEmpty()) {
                                String path = RESTService.appPrefix(webApp, ((Object)((Object)application)).getClass());
                                String prefix = path != null ? "/" + path + this.wildcard : "/" + this.wildcard;
                                pojoConfigurations = PojoUtil.findPojoConfig((Collection)pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp);
                                this.deployApplication(appInfo, webApp.contextRoot, restEjbs, classLoader, injections, owbCtx, context, additionalProviders, pojoConfigurations, application, prefix);
                            }
                        } else {
                            this.fullServletDeployment(appInfo, webApp, webContext, restEjbs, classLoader, injections, owbCtx, context, additionalProviders, pojoConfigurations);
                        }
                    }
                    break block41;
                }
                this.fullServletDeployment(appInfo, webApp, webContext, restEjbs, classLoader, injections, owbCtx, context, additionalProviders, pojoConfigurations);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }

    public Application wrapApplication(AppInfo appInfo, Application application) {
        if (RESTService.hasBindings(application)) {
            return application;
        }
        return "true".equalsIgnoreCase(appInfo.properties.getProperty("openejb.cxf-rs.cache-application", SystemInstance.get().getOptions().get("openejb.cxf-rs.cache-application", "true"))) ? new InternalApplication(application) : application;
    }

    public static boolean hasBindings(Application application) {
        return RESTService.hasBindings(application.getClass());
    }

    private static boolean hasBindings(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (NameBinding.class != metaAnnotation.annotationType()) continue;
                return true;
            }
        }
        return false;
    }

    private void addAppProvidersIfNeeded(AppInfo appInfo, WebAppInfo webApp, ClassLoader classLoader, Collection<Object> additionalProviders) {
        boolean hasExplicitlyDefinedApplication = webApp.restApplications.stream().map(s -> {
            try {
                return classLoader.loadClass((String)s);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }).filter(Objects::nonNull).anyMatch(aClass -> aClass.getDeclaredMethods().length > 0);
        if (this.useDiscoveredProviders(appInfo, !hasExplicitlyDefinedApplication)) {
            HashSet<String> jaxRsProviders = new HashSet<String>(webApp.jaxRsProviders);
            jaxRsProviders.addAll(appInfo.jaxRsProviders);
            additionalProviders.addAll(this.appProviders(jaxRsProviders, classLoader));
        }
    }

    private void addEjbToApplication(Application application, Map<String, EJBRestServiceInfo> restEjbs) {
        for (Map.Entry<String, EJBRestServiceInfo> ejb : restEjbs.entrySet()) {
            application.getClasses().add(ejb.getValue().context.getBeanClass());
        }
    }

    private void fullServletDeployment(AppInfo appInfo, WebAppInfo webApp, WebContext webContext, Map<String, EJBRestServiceInfo> restEjbs, ClassLoader classLoader, Collection<Injection> injections, WebBeansContext owbCtx, Context context, Collection<Object> additionalProviders, Collection<IdPropertiesInfo> initPojoConfigurations) {
        Collection pojoConfigurations = null;
        boolean useApp = false;
        Object appPrefix = webApp.contextRoot;
        for (String app : webApp.restApplications) {
            String path;
            Application appInstance;
            Class<?> appClazz;
            appPrefix = webApp.contextRoot;
            if (!((String)appPrefix).endsWith("/")) {
                appPrefix = (String)appPrefix + "/";
            }
            try {
                appClazz = classLoader.loadClass(app);
                appInstance = (Application)Application.class.cast(appClazz.newInstance());
                if (owbCtx.getBeanManagerImpl().isInUse()) {
                    try {
                        webContext.inject((Object)appInstance);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                throw new OpenEJBRestRuntimeException("can't create class " + app, e);
            }
            if ((path = RESTService.appPrefix(webApp, appClazz)) != null) {
                appPrefix = (String)appPrefix + path;
            }
            Set classes = appInstance.getClasses();
            Set singletons = appInstance.getSingletons();
            for (Class clazz : classes) {
                if (!RESTService.isProvider(clazz)) continue;
                additionalProviders.add(clazz);
            }
            for (Object obj : singletons) {
                if (obj == null || !RESTService.isProvider(obj.getClass())) continue;
                additionalProviders.add(obj);
            }
            for (Object o : singletons) {
                if (o == null || additionalProviders.contains(o)) continue;
                if (this.hasEjbAndIsNotAManagedBean(restEjbs, o.getClass().getName())) {
                    this.deployEJB(appInfo.appId, webApp.contextRoot, (String)appPrefix, restEjbs.get((Object)o.getClass().getName()).context, additionalProviders, appInfo.services);
                    continue;
                }
                pojoConfigurations = PojoUtil.findPojoConfig((Collection)pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp);
                this.deploySingleton(appInfo.appId, webApp.contextRoot, (String)appPrefix, o, appInstance, classLoader, additionalProviders, new ServiceConfiguration(PojoUtil.findConfiguration((Collection)pojoConfigurations, (String)o.getClass().getName()), (Collection)appInfo.services));
            }
            for (Class clazz : classes) {
                if (additionalProviders.contains(clazz)) continue;
                if (this.hasEjbAndIsNotAManagedBean(restEjbs, clazz.getName())) {
                    this.deployEJB(appInfo.appId, webApp.contextRoot, (String)appPrefix, restEjbs.get((Object)clazz.getName()).context, additionalProviders, appInfo.services);
                    continue;
                }
                pojoConfigurations = PojoUtil.findPojoConfig((Collection)pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp);
                this.deployPojo(appInfo.appId, webApp.contextRoot, (String)appPrefix, clazz, appInstance, classLoader, injections, context, owbCtx, additionalProviders, new ServiceConfiguration(PojoUtil.findConfiguration((Collection)pojoConfigurations, (String)clazz.getName()), (Collection)appInfo.services));
            }
            useApp = useApp || classes.size() + singletons.size() > 0;
            LOGGER.info("REST application deployed: " + app);
        }
        if (!useApp) {
            if (webApp.restApplications.isEmpty() || webApp.restApplications.size() > 1) {
                appPrefix = webApp.contextRoot;
            }
            HashSet restClasses = new HashSet(webApp.restClass);
            restClasses.addAll(webApp.ejbRestServices);
            for (String clazz : restClasses) {
                if (restEjbs.containsKey(clazz)) {
                    BeanContext ctx = restEjbs.get((Object)clazz).context;
                    if (this.hasEjbAndIsNotAManagedBean(restEjbs, clazz)) {
                        this.deployEJB(appInfo.appId, webApp.contextRoot, (String)appPrefix, restEjbs.get((Object)clazz).context, additionalProviders, appInfo.services);
                        continue;
                    }
                    this.deployPojo(appInfo.appId, webApp.contextRoot, (String)appPrefix, ctx.getBeanClass(), null, ctx.getClassLoader(), ctx.getInjections(), context, owbCtx, additionalProviders, new ServiceConfiguration(ctx.getProperties(), (Collection)appInfo.services));
                    continue;
                }
                try {
                    Class<?> loadedClazz = classLoader.loadClass(clazz);
                    pojoConfigurations = PojoUtil.findPojoConfig(pojoConfigurations, (AppInfo)appInfo, (WebAppInfo)webApp);
                    this.deployPojo(appInfo.appId, webApp.contextRoot, (String)appPrefix, loadedClazz, null, classLoader, injections, context, owbCtx, additionalProviders, new ServiceConfiguration(PojoUtil.findConfiguration((Collection)pojoConfigurations, (String)loadedClazz.getName()), (Collection)appInfo.services));
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBRestRuntimeException("can't find class " + clazz, e);
                }
            }
        }
    }

    protected static void logOldDeploymentUsage(String clazz) {
        LOGGER.info("Using deployment by endpoint instead of by application for JAXRS deployment because an old configuration (by class/ejb) was found on " + clazz);
    }

    private void deployApplication(AppInfo appInfo, String contextRoot, Map<String, EJBRestServiceInfo> restEjbs, ClassLoader classLoader, Collection<Injection> injections, WebBeansContext owbCtx, Context context, Collection<Object> additionalProviders, Collection<IdPropertiesInfo> pojoConfigurations, Application application, String prefix) {
        String base;
        Application original;
        Properties configuration = InternalApplication.class.equals(application.getClass()) ? ((original = ((InternalApplication)((Object)InternalApplication.class.cast(application))).getOriginal()) == null ? PojoUtil.findConfiguration(pojoConfigurations, (String)"jaxrs-application") : PojoUtil.findConfiguration(pojoConfigurations, (String)original.getClass().getName())) : PojoUtil.findConfiguration(pojoConfigurations, (String)application.getClass().getName());
        if (configuration == null) {
            configuration = PojoUtil.findConfiguration(pojoConfigurations, (String)"jaxrs-application");
        }
        if (configuration != null) {
            LOGGER.info("Registered JAX-RS Configuration: " + String.valueOf(configuration));
        }
        String nopath = (base = this.getAddress(contextRoot)).endsWith("/") && prefix.startsWith("/") ? base + prefix.substring(1) : base + prefix;
        RsHttpListener listener = this.createHttpListener();
        String host = this.findHost(contextRoot, appInfo.webApps);
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(appInfo.appId, contextRoot, listener, classLoader, nopath.substring(NOPATH_PREFIX.length() - 1), host, this.auth, this.realm);
        this.services.add(new DeployedService(address.complete, contextRoot, application.getClass().getName(), appInfo.appId));
        listener.deployApplication(application, address.complete.substring(0, address.complete.length() - this.wildcard.length()), nopath.substring(NOPATH_PREFIX.length(), nopath.length() - this.wildcard.length()), additionalProviders, restEjbs, classLoader, injections, context, owbCtx, new ServiceConfiguration(configuration, (Collection)appInfo.services));
    }

    private String findHost(String context, Collection<WebAppInfo> webs) {
        for (WebAppInfo web : webs) {
            if (!context.equals(web.contextRoot)) continue;
            return web.host != null ? web.host : this.virtualHost;
        }
        return this.virtualHost;
    }

    private static String appPrefix(WebAppInfo info, Class<?> appClazz) {
        StringBuilder builder = null;
        for (ServletInfo s : info.servlets) {
            if (s.mappings.isEmpty()) continue;
            String mapping = null;
            String name = appClazz.getName();
            if (name.equals(s.servletClass) || name.equals(s.servletName) || "jakarta.ws.rs.core.Application ".equals(s.servletName)) {
                mapping = (String)s.mappings.iterator().next();
            } else {
                for (ParamValueInfo pvi : s.initParams) {
                    if (!"jakarta.ws.rs.Application".equals(pvi.name) && !Application.class.getName().equals(pvi.name)) continue;
                    mapping = (String)s.mappings.iterator().next();
                    break;
                }
            }
            if (mapping == null) continue;
            if (mapping.endsWith("/*")) {
                mapping = mapping.substring(0, mapping.length() - 2);
            }
            if (mapping.startsWith("/")) {
                mapping = mapping.substring(1);
            }
            builder = new StringBuilder();
            builder.append(mapping);
            break;
        }
        if (builder != null) {
            return builder.toString();
        }
        ApplicationPath path = appClazz.getAnnotation(ApplicationPath.class);
        if (path != null) {
            String appPath = path.value();
            try {
                appPath = URLDecoder.decode(appPath, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new UncheckedIOException(e);
            }
            if (appPath.endsWith("*")) {
                appPath = appPath.substring(0, appPath.length() - 1);
            }
            builder = new StringBuilder();
            if (appPath.startsWith("/")) {
                builder.append(appPath.substring(1));
            } else {
                builder.append(appPath);
            }
        }
        if (builder == null) {
            return null;
        }
        return builder.toString();
    }

    private static <T> boolean isProvider(Class<T> clazz) {
        return MessageBodyReader.class.isAssignableFrom(clazz) || MessageBodyWriter.class.isAssignableFrom(clazz) || ParamConverter.class.isAssignableFrom(clazz) || ContainerRequestFilter.class.isAssignableFrom(clazz) || ContainerResponseFilter.class.isAssignableFrom(clazz) || ReaderInterceptor.class.isAssignableFrom(clazz) || WriterInterceptor.class.isAssignableFrom(clazz) || ParamConverterProvider.class.isAssignableFrom(clazz) || ContextResolver.class.isAssignableFrom(clazz) || Feature.class.isAssignableFrom(clazz) || new MetaAnnotatedClass(clazz).isAnnotationPresent(Provider.class);
    }

    private boolean hasEjbAndIsNotAManagedBean(Map<String, EJBRestServiceInfo> restEjbs, String clazz) {
        return restEjbs.containsKey(clazz) && !BeanType.MANAGED.equals((Object)restEjbs.get((Object)clazz).context.getComponentType());
    }

    private boolean useDiscoveredProviders(AppInfo appInfo) {
        return this.useDiscoveredProviders(appInfo, true);
    }

    private boolean useDiscoveredProviders(AppInfo appInfo, boolean defaultValue) {
        String value = appInfo.properties.getProperty(OPENEJB_JAXRS_PROVIDERS_AUTO_PROP);
        if (value != null) {
            return "true".equalsIgnoreCase(value.trim());
        }
        return SystemInstance.get().getOptions().get(OPENEJB_JAXRS_PROVIDERS_AUTO_PROP, defaultValue);
    }

    private Collection<Object> appProviders(Collection<String> jaxRsProviders, ClassLoader classLoader) {
        HashSet<Object> additionalProviders = new HashSet<Object>();
        for (String name : jaxRsProviders) {
            try {
                Class<?> providerClass = classLoader.loadClass(name);
                if (providerClass.getAnnotation(Deprecated.class) != null) continue;
                additionalProviders.add(providerClass);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warning("can't load '" + name + "'", (Throwable)e);
            }
        }
        return additionalProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterApplicationCreated(@Observes AssemblerAfterApplicationCreated event) {
        if (!this.enabled) {
            return;
        }
        AppInfo appInfo = event.getApp();
        if ("false".equalsIgnoreCase(appInfo.properties.getProperty("openejb.jaxrs.on", "true"))) {
            return;
        }
        this.quickCheckIfOldDeploymentShouldBeUsedFromEjbConfig(appInfo);
        if (this.deployedApplications.add(appInfo)) {
            if (appInfo.webApps.size() == 0) {
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader appClassLoader = RESTService.getClassLoader(this.containerSystem.getAppContext((Object)appInfo.appId).getClassLoader());
                Thread.currentThread().setContextClassLoader(appClassLoader);
                try {
                    Map<String, EJBRestServiceInfo> restEjbs = this.getRestEjbs(appInfo, null);
                    if (restEjbs.isEmpty()) {
                        return;
                    }
                    Collection<Object> providers = this.useDiscoveredProviders(appInfo) ? this.appProviders(appInfo.jaxRsProviders, appClassLoader) : new ArrayList();
                    if ("true".equalsIgnoreCase(appInfo.properties.getProperty(OPENEJB_USE_APPLICATION_PROPERTY, APPLICATION_DEPLOYMENT))) {
                        InternalApplication application = new InternalApplication(null);
                        this.addEjbToApplication(application, restEjbs);
                        ArrayList<IdPropertiesInfo> pojoConfigurations = new ArrayList<IdPropertiesInfo>();
                        BeanContext comp = null;
                        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                            for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                                if (comp != null) break;
                                if (!bean.ejbClass.equals(BeanContext.Comp.class.getName())) continue;
                                comp = this.containerSystem.getBeanContext((Object)bean.ejbDeploymentId);
                                break;
                            }
                            if (ejbJar.pojoConfigurations == null) continue;
                            pojoConfigurations.addAll(ejbJar.pojoConfigurations);
                        }
                        if (appInfo.pojoConfigurations != null) {
                            pojoConfigurations.addAll(appInfo.pojoConfigurations);
                        }
                        Map.Entry<String, EJBRestServiceInfo> next = restEjbs.entrySet().iterator().next();
                        if (comp == null) {
                            comp = next.getValue().context;
                        }
                        this.deployApplication(appInfo, next.getValue().path, restEjbs, comp.getClassLoader(), comp.getInjections(), this.containerSystem.getAppContext((Object)appInfo.appId).getWebBeansContext(), comp.getJndiContext(), providers, pojoConfigurations, application, this.wildcard);
                    }
                    for (Map.Entry<String, EJBRestServiceInfo> ejb : restEjbs.entrySet()) {
                        BeanContext ctx = ejb.getValue().context;
                        if (BeanType.MANAGED.equals((Object)ctx.getComponentType())) {
                            this.deployPojo(appInfo.appId, "", ejb.getValue().path, ctx.getBeanClass(), null, ctx.getClassLoader(), ctx.getInjections(), ctx.getJndiContext(), this.containerSystem.getAppContext((Object)appInfo.appId).getWebBeansContext(), providers, new ServiceConfiguration(ctx.getProperties(), (Collection)appInfo.services));
                            continue;
                        }
                        this.deployEJB(appInfo.appId, "", ejb.getValue().path, ctx, providers, appInfo.services);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            } else {
                for (WebAppInfo webApp : appInfo.webApps) {
                    this.afterApplicationCreated(appInfo, webApp);
                }
            }
        }
    }

    private void quickCheckIfOldDeploymentShouldBeUsedFromEjbConfig(AppInfo appInfo) {
        if (appInfo.properties.getProperty(OPENEJB_USE_APPLICATION_PROPERTY) != null) {
            return;
        }
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                BeanContext beanContext;
                if (!bean.restService || (beanContext = this.containerSystem.getBeanContext((Object)bean.ejbDeploymentId)) == null || !this.containsJaxRsConfiguration(beanContext.getProperties())) continue;
                appInfo.properties.setProperty(OPENEJB_USE_APPLICATION_PROPERTY, "false");
                RESTService.logOldDeploymentUsage(bean.ejbClass);
                return;
            }
        }
    }

    protected abstract boolean containsJaxRsConfiguration(Properties var1);

    protected Map<String, EJBRestServiceInfo> getRestEjbs(AppInfo appInfo, String webapp) {
        HashMap<String, BeanContext> beanContexts = new HashMap<String, BeanContext>();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            if (ejbJar.webapp && webapp != null && !ejbJar.moduleId.equals(webapp)) continue;
            for (Object bean : ejbJar.enterpriseBeans) {
                BeanContext beanContext;
                if (!((EnterpriseBeanInfo)bean).restService || (beanContext = this.containerSystem.getBeanContext((Object)((EnterpriseBeanInfo)bean).ejbDeploymentId)) == null) continue;
                beanContexts.put(((EnterpriseBeanInfo)bean).ejbClass, beanContext);
            }
        }
        HashMap<String, EJBRestServiceInfo> restEjbs = new HashMap<String, EJBRestServiceInfo>();
        for (WebAppInfo webAppInfo : appInfo.webApps) {
            for (String ejb : webAppInfo.ejbRestServices) {
                if (!beanContexts.containsKey(ejb)) continue;
                restEjbs.put(ejb, new EJBRestServiceInfo(webAppInfo.contextRoot, (BeanContext)beanContexts.get(ejb)));
            }
        }
        for (Map.Entry entry : beanContexts.entrySet()) {
            String clazz = (String)entry.getKey();
            if (restEjbs.containsKey(clazz)) continue;
            String context = null;
            if (!OLD_WEBSERVICE_DEPLOYMENT) {
                context = appInfo.appId != null && !appInfo.appId.isEmpty() ? appInfo.appId : ((BeanContext)entry.getValue()).getModuleName();
            }
            restEjbs.put(clazz, new EJBRestServiceInfo(context, (BeanContext)beanContexts.get(clazz)));
        }
        beanContexts.clear();
        return restEjbs;
    }

    private void deploySingleton(String appId, String web, String contextRoot, Object o, Application appInstance, ClassLoader classLoader, Collection<Object> additionalProviders, ServiceConfiguration configuration) {
        String nopath = this.getAddress(contextRoot, o.getClass());
        RsHttpListener listener = this.createHttpListener();
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(appId, web, listener, classLoader, nopath.substring(NOPATH_PREFIX.length() - 1), this.virtualHost, this.auth, this.realm);
        this.services.add(new DeployedService(address.complete, web, o.getClass().getName(), appId));
        listener.deploySingleton(contextRoot, RESTService.getFullContext(address.base, contextRoot), o, appInstance, additionalProviders, configuration);
        LOGGER.info("deployed REST singleton: " + String.valueOf(o));
    }

    private void deployPojo(String appId, String web, String contextRoot, Class<?> loadedClazz, Application app, ClassLoader classLoader, Collection<Injection> injections, Context context, WebBeansContext owbCtx, Collection<Object> additionalProviders, ServiceConfiguration config) {
        if (loadedClazz.isInterface()) {
            return;
        }
        String nopath = this.getAddress(contextRoot, loadedClazz);
        RsHttpListener listener = this.createHttpListener();
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(appId, web, listener, classLoader, nopath.substring(NOPATH_PREFIX.length() - 1), this.virtualHost, this.auth, this.realm);
        this.services.add(new DeployedService(address.complete, contextRoot, loadedClazz.getName(), appId));
        listener.deployPojo(classLoader, contextRoot, RESTService.getFullContext(address.base, contextRoot), loadedClazz, app, injections, context, owbCtx, additionalProviders, config);
        LOGGER.info("REST Service: " + address.complete + "  -> Pojo " + loadedClazz.getName());
    }

    private void deployEJB(String appId, String web, String context, BeanContext beanContext, Collection<Object> additionalProviders, Collection<ServiceInfo> serviceInfos) {
        String nopath = this.getAddress(context, beanContext.getBeanClass());
        RsHttpListener listener = this.createHttpListener();
        RsRegistry.AddressInfo address = this.rsRegistry.createRsHttpListener(appId, web, listener, beanContext.getClassLoader(), nopath.substring(NOPATH_PREFIX.length() - 1), this.virtualHost, this.auth, this.realm);
        this.services.add(new DeployedService(address.complete, context, beanContext.getBeanClass().getName(), appId));
        listener.deployEJB(context, RESTService.getFullContext(address.base, context), beanContext, additionalProviders, new ServiceConfiguration(beanContext.getProperties(), serviceInfos));
        LOGGER.info("REST Service: " + address.complete + "  -> EJB " + beanContext.getEjbName());
    }

    protected abstract RsHttpListener createHttpListener();

    private static String getFullContext(String address, String context) {
        if (context == null) {
            return address;
        }
        if (context.isEmpty() && address.contains("/")) {
            return address.substring(0, address.lastIndexOf("/"));
        }
        String webCtx = context;
        while (webCtx.startsWith("/")) {
            webCtx = webCtx.substring(1);
        }
        try {
            URL url = new URL(address);
            int port = url.getPort();
            if (port > 0) {
                return url.getProtocol() + "://" + url.getHost() + ":" + port + "/" + webCtx;
            }
            return url.getProtocol() + "://" + url.getHost() + "/" + webCtx;
        }
        catch (MalformedURLException e) {
            throw new OpenEJBRestRuntimeException("bad url: " + address, e);
        }
    }

    private Class<?> findPath(Class<?> clazz) {
        Class<?> usedClass = clazz;
        while (usedClass.getAnnotation(Path.class) == null && usedClass.getSuperclass() != null) {
            usedClass = usedClass.getSuperclass();
        }
        return usedClass;
    }

    private String getAddress(String context, Class<?> clazz) {
        Class<?>[] itfs;
        Object root = this.getAddress(context);
        Class<?> usedClass = this.findPath(clazz);
        if ((usedClass == null || Object.class.equals(usedClass)) && (itfs = clazz.getInterfaces()) != null) {
            Class<?> c;
            Class<?>[] classArray = itfs;
            int n = classArray.length;
            for (int i = 0; i < n && (usedClass = this.findPath(c = classArray[i])).getAnnotation(Path.class) == null; ++i) {
            }
        }
        if (usedClass == null || usedClass.getAnnotation(Path.class) == null) {
            throw new IllegalArgumentException("no @Path annotation on " + clazz.getName());
        }
        String builtUrl = null;
        try {
            builtUrl = UriBuilder.fromUri((URI)new URI((String)root)).path(usedClass).build(new Object[0]).toURL().toString();
            return this.replaceParams(builtUrl);
        }
        catch (IllegalArgumentException iae) {
            if (builtUrl != null) {
                return builtUrl;
            }
            for (Class<?> current = usedClass; current != null && !Object.class.equals(current); current = current.getSuperclass()) {
                Path path = current.getAnnotation(Path.class);
                if (path == null) continue;
                String classPath = path.value();
                if (classPath.startsWith("/")) {
                    classPath = classPath.substring(1);
                }
                if (!((String)root).endsWith("/")) {
                    root = (String)root + "/";
                }
                return this.replaceParams((String)root + classPath);
            }
            throw new OpenEJBRestRuntimeException("can't built the service mapping for service '" + usedClass.getName() + "'", iae);
        }
        catch (MalformedURLException e) {
            throw new OpenEJBRestRuntimeException("url is malformed", e);
        }
        catch (URISyntaxException e) {
            throw new OpenEJBRestRuntimeException("uri syntax is not correct", e);
        }
    }

    private String getAddress(String context) {
        Object root = NOPATH_PREFIX;
        if (context != null) {
            root = context.startsWith("/") ? (String)root + context.substring(1) : (String)root + context;
        }
        return root;
    }

    private String replaceParams(String url) {
        String managedUrl = url.replaceAll("\\{[^}]*\\}.*", this.wildcard);
        if (managedUrl.endsWith(this.wildcard)) {
            return managedUrl;
        }
        return managedUrl + "/" + this.wildcard;
    }

    private void undeployRestObject(String appId, String context) {
        HttpListener listener = this.rsRegistry.removeListener(appId, context);
        if (listener != null) {
            if (BasicAuthHttpListenerWrapper.class.isInstance(listener)) {
                listener = ((BasicAuthHttpListenerWrapper)BasicAuthHttpListenerWrapper.class.cast(listener)).getHttpListener();
            }
            this.checkUndeploy(listener);
        }
    }

    private void checkUndeploy(HttpListener listener) {
        if (RsHttpListener.class.isInstance(listener)) {
            ((RsHttpListener)RsHttpListener.class.cast(listener)).undeploy();
        }
    }

    private static ClassLoader getClassLoader(ClassLoader classLoader) {
        ClassLoader cl = classLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = RESTService.class.getClassLoader();
        }
        return cl;
    }

    public void undeploy(@Observes AssemblerBeforeApplicationDestroyed event) {
        AppInfo app = event.getApp();
        boolean removed = this.deployedApplications.remove(app);
        if (removed) {
            for (WebAppInfo webApp : app.webApps) {
                ArrayList<DeployedService> toRemove = new ArrayList<DeployedService>();
                for (DeployedService service : this.services) {
                    if (!service.isInWebApp(app.appId, webApp)) continue;
                    this.undeployRestObject(app.appId, service.address);
                    toRemove.add(service);
                }
                this.services.removeAll(toRemove);
                this.deployedWebApps.remove(webApp);
            }
        }
    }

    public void start() throws ServiceException {
        SystemInstance.get().setComponent(RESTService.class, (Object)this);
        this.beforeStart();
        this.containerSystem = (CoreContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        if (this.assembler != null) {
            SystemInstance.get().addObserver((Object)this);
            for (AppInfo appInfo : this.assembler.getDeployedApplications()) {
                AppContext appContext = this.containerSystem.getAppContext((Object)appInfo.appId);
                this.afterApplicationCreated(new AssemblerAfterApplicationCreated(appInfo, appContext, null));
            }
        }
    }

    protected void beforeStart() {
        this.rsRegistry = (RsRegistry)SystemInstance.get().getComponent(RsRegistry.class);
        if (this.rsRegistry == null && SystemInstance.get().getComponent(HttpListenerRegistry.class) != null) {
            this.rsRegistry = new RsRegistryImpl();
        }
    }

    public void stop() throws ServiceException {
        if (this.assembler != null) {
            SystemInstance.get().removeObserver((Object)this);
            for (AppInfo appInfo : new ArrayList<AppInfo>(this.deployedApplications)) {
                this.undeploy(new AssemblerBeforeApplicationDestroyed(appInfo, null));
            }
        }
        for (DeployedService service : this.services) {
            this.undeployRestObject(service.appId, service.address);
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be invoked directly");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be invoked directly");
    }

    public String getIP() {
        return IP;
    }

    public int getPort() {
        return -1;
    }

    public void init(Properties props) throws Exception {
        if (props == null) {
            return;
        }
        this.virtualHost = props.getProperty("virtualHost", "localhost");
        this.auth = props.getProperty("auth", "NONE");
        this.realm = props.getProperty("realm", "PropertiesLogin");
        this.enabled = ServiceManager.isEnabled((Properties)props);
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public List<DeployedService> getServices() {
        return this.services;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public static class DeployedService {
        public String address;
        public String webapp;
        public String origin;
        public String appId;

        public DeployedService(String address, String webapp, String origin, String appId) {
            this.address = address;
            this.webapp = webapp;
            this.origin = origin;
            this.appId = appId;
        }

        public boolean isInWebApp(String appId, WebAppInfo webApp) {
            boolean appTest = !(appId == null && this.appId != null || appId != null && !appId.equals(this.appId));
            return appTest && this.cleanWeb(this.webapp).equals(this.cleanWeb(webApp.contextRoot));
        }

        private String cleanWeb(String s) {
            if (s == null) {
                return "";
            }
            if (s.startsWith("/")) {
                return this.cleanWeb(s.substring(1));
            }
            int i = s.indexOf("##");
            if (i > 0) {
                return this.cleanWeb(s.substring(0, i));
            }
            if ("ROOT".equals(s)) {
                return "";
            }
            return s;
        }
    }
}

