/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal;

import java.util.BitSet;
import wiremock.com.github.jknack.handlebars.HandlebarsError;
import wiremock.com.github.jknack.handlebars.HandlebarsException;
import wiremock.org.antlr.v4.runtime.ANTLRErrorListener;
import wiremock.org.antlr.v4.runtime.CharStream;
import wiremock.org.antlr.v4.runtime.CommonToken;
import wiremock.org.antlr.v4.runtime.CommonTokenStream;
import wiremock.org.antlr.v4.runtime.IntStream;
import wiremock.org.antlr.v4.runtime.Parser;
import wiremock.org.antlr.v4.runtime.RecognitionException;
import wiremock.org.antlr.v4.runtime.Recognizer;
import wiremock.org.antlr.v4.runtime.atn.ATNConfigSet;
import wiremock.org.antlr.v4.runtime.dfa.DFA;
import wiremock.org.antlr.v4.runtime.misc.Interval;
import wiremock.org.apache.commons.lang3.StringUtils;
import wiremock.org.apache.commons.lang3.Validate;

public class HbsErrorReporter
implements ANTLRErrorListener {
    private String filename;

    public HbsErrorReporter(String filename) {
        this.filename = Validate.notNull(filename, "A filename is required.", new Object[0]);
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        int column = Math.max(1, charPositionInLine);
        CommonToken offendingToken = (CommonToken)offendingSymbol;
        StringBuilder message = new StringBuilder();
        message.append(this.filename).append(":").append(line).append(":").append(column).append(": ");
        String stacktrace = "";
        int reasonStart = message.length();
        if (offendingToken == null) {
            Object[] parts = StringUtils.split(msg, "\n");
            message.append(parts[0]);
            stacktrace = "\n" + StringUtils.join(parts, "\n", 1, parts.length);
        } else {
            message.append("found: '").append(offendingToken.getText()).append("', ");
            message.append("expected: '").append(msg).append("'");
        }
        String reason = message.substring(reasonStart);
        message.append("\n");
        int evidenceStat = message.length();
        String[] lines = this.lines(recognizer);
        this.underline(message, lines, line, column);
        String prevLine = this.lineAt(lines, line > lines.length ? lines.length : line - 2);
        String nextLine = this.lineAt(lines, line);
        String evidence = prevLine + "\n" + message.substring(evidenceStat) + "\n" + nextLine;
        message.append(stacktrace);
        HandlebarsError error = new HandlebarsError(this.filename, line, column, reason.replace("<EOF>", "EOF"), evidence, message.toString());
        throw new HandlebarsException(error);
    }

    private String lineAt(String[] lines, int number) {
        if (number >= 0 && number < lines.length) {
            return lines[number];
        }
        return "";
    }

    private void underline(StringBuilder message, String[] lines, int line, int charPositionInLine) {
        String errorLine = lines[Math.min(line - 1, lines.length - 1)];
        message.append(errorLine).append("\n");
        for (int i = 0; i < charPositionInLine; ++i) {
            message.append(" ");
        }
        message.append("^");
    }

    private String[] lines(Recognizer<?, ?> recognizer) {
        IntStream stream = recognizer.getInputStream();
        if (stream instanceof CommonTokenStream) {
            stream = ((CommonTokenStream)stream).getTokenSource().getInputStream();
        }
        String input = stream instanceof CharStream ? ((CharStream)stream).getText(new Interval(0, stream.size())) : stream.toString();
        String[] lines = input.split("\n");
        return lines;
    }

    @Override
    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
    }

    @Override
    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
    }

    @Override
    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
    }
}

